/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.crafting.refining;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidIngredient
implements Predicate<FluidStack> {
    private final Tag<Fluid> tag;
    private final Fluid fluid;

    public FluidIngredient(Tag<Fluid> tag) {
        this.tag = tag;
        this.fluid = null;
    }

    public FluidIngredient(Fluid fluid) {
        this.fluid = fluid;
        this.tag = null;
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        return this.tag != null && fluidStack.getFluid().func_207185_a(this.tag) || this.fluid != null && fluidStack.getFluid() == this.fluid;
    }

    public static FluidIngredient deserialize(JsonObject json) {
        if (json.has("tag") && json.has("fluid")) {
            throw new JsonSyntaxException("Fluid ingredient should have 'tag' or 'fluid', not both");
        }
        if (json.has("tag")) {
            ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
            return new FluidIngredient((Tag<Fluid>)new FluidTags.Wrapper(id));
        }
        if (json.has("fluid")) {
            ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
            return new FluidIngredient((Fluid)ForgeRegistries.FLUIDS.getValue(id));
        }
        throw new JsonSyntaxException("Fluid ingredient should have either 'tag' or 'fluid'");
    }

    public static FluidIngredient read(PacketBuffer buffer) {
        boolean isTag = buffer.readBoolean();
        ResourceLocation id = buffer.func_192575_l();
        return isTag ? new FluidIngredient((Tag<Fluid>)new FluidTags.Wrapper(id)) : new FluidIngredient((Fluid)ForgeRegistries.FLUIDS.getValue(id));
    }

    public void write(PacketBuffer buffer) {
        boolean isTag = this.tag != null;
        buffer.writeBoolean(isTag);
        if (isTag) {
            buffer.func_192572_a(this.tag.func_199886_b());
        } else if (this.fluid != null) {
            buffer.func_192572_a(Objects.requireNonNull(this.fluid.getRegistryName()));
        } else {
            buffer.func_192572_a(new ResourceLocation("null"));
        }
    }
}

