/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.wire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.wire.WireNetwork;

public final class WireNetworkManager {
    private static final Collection<LazyOptional<WireNetwork>> NETWORK_LIST = new ArrayList<LazyOptional<WireNetwork>>();

    private WireNetworkManager() {
        throw new IllegalAccessError("Utility class");
    }

    @Nullable
    public static WireNetwork get(IBlockReader world, BlockPos pos) {
        return (WireNetwork)WireNetworkManager.getLazy(world, pos).orElse(null);
    }

    public static LazyOptional<WireNetwork> getLazy(IBlockReader world, BlockPos pos) {
        for (LazyOptional<WireNetwork> network : NETWORK_LIST) {
            WireNetwork net;
            if (!network.isPresent() || !(net = (WireNetwork)network.orElseThrow(IllegalStateException::new)).contains(world, pos)) continue;
            return network;
        }
        WireNetwork network = WireNetwork.buildNetwork(world, pos);
        LazyOptional lazy = LazyOptional.of(() -> network);
        NETWORK_LIST.add((LazyOptional<WireNetwork>)lazy);
        SilentMechanisms.LOGGER.debug("create network {}", (Object)network);
        return lazy;
    }

    public static void invalidateNetwork(IBlockReader world, BlockPos pos) {
        Collection toRemove = NETWORK_LIST.stream().filter(n -> n.isPresent() && ((WireNetwork)n.orElseThrow(IllegalStateException::new)).contains(world, pos)).collect(Collectors.toList());
        toRemove.forEach(WireNetworkManager::invalidateNetwork);
    }

    private static void invalidateNetwork(LazyOptional<WireNetwork> network) {
        SilentMechanisms.LOGGER.debug("invalidateNetwork {}", network);
        NETWORK_LIST.removeIf(n -> n.isPresent() && n.equals(network));
        network.invalidate();
    }

    public static void invalidateNetworks() {
        NETWORK_LIST.clear();
    }

    public static int getNetworkCount() {
        return NETWORK_LIST.size();
    }
}

