/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.garden;

import java.io.File;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.garden.BlockBambooExt;
import shadows.apotheosis.garden.BlockCactusExt;
import shadows.apotheosis.garden.BlockReedExt;
import shadows.apotheosis.garden.EnderLeashItem;
import shadows.placebo.config.Configuration;
import shadows.placebo.util.PlaceboUtil;

public class GardenModule {
    public static int maxCactusHeight = 5;
    public static int maxReedHeight = 255;
    public static int maxBambooHeight = 32;

    @SubscribeEvent
    public void setup(Apotheosis.ApotheosisSetup e) {
        Configuration c = new Configuration(new File(Apotheosis.configDir, "garden.cfg"));
        maxCactusHeight = c.getInt("Cactus Height", "general", maxCactusHeight, 1, 255, "The max height a stack of cacti may grow to.  Vanilla is 3.");
        maxReedHeight = c.getInt("Reed Height", "general", maxReedHeight, 1, 255, "The max height a stack of reeds may grow to.  Vanilla is 3.");
        maxBambooHeight = c.getInt("Bamboo Height", "general", maxBambooHeight, 1, 255, "The max height a stack of bamboo may grow to.  Vanilla is 16.");
        if (c.hasChanged()) {
            c.save();
        }
        Apotheosis.HELPER.addShapeless((Object)ApotheosisObjects.FARMERS_LEASH, new Object[]{Items.field_151079_bi, Items.field_151058_ca, Items.field_151043_k});
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        PlaceboUtil.registerOverrideBlock((Block)new BlockCactusExt(), (String)"apotheosis");
        PlaceboUtil.registerOverrideBlock((Block)new BlockReedExt(), (String)"apotheosis");
        PlaceboUtil.registerOverrideBlock((Block)new BlockBambooExt(), (String)"apotheosis");
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().register(new EnderLeashItem().setRegistryName("farmers_leash"));
        ComposterBlock.field_220299_b.put((Object)Blocks.field_150434_aF, 0.5f);
        ComposterBlock.field_220299_b.put((Object)Blocks.field_196608_cF, 0.5f);
    }

    public static <T extends Comparable<T>> BlockState update(BlockState state) {
        BlockState ret = ((Block)state.func_177230_c().delegate.get()).func_176223_P();
        for (Map.Entry ent : state.func_206871_b().entrySet()) {
            ret = (BlockState)state.func_206870_a((IProperty)ent.getKey(), (Comparable)ent.getValue());
        }
        return ret;
    }
}

