/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.gen.WorldFeature;
import shadows.apotheosis.deadly.gen.WorldGenerator;
import shadows.apotheosis.ench.asm.EnchHooks;
import shadows.apotheosis.util.ArmorSet;
import shadows.apotheosis.util.NameHelper;
import shadows.placebo.util.AttributeHelper;
import shadows.placebo.util.PlaceboUtil;

public class BossItem
extends WorldFeature.WorldFeatureItem {
    public static final List<Effect> POTIONS = new ArrayList<Effect>();
    public static final List<Enchantment> BOW_ENCHANTMENTS = PlaceboUtil.asList((Object[])new Enchantment[]{Enchantments.field_185304_p, Enchantments.field_185307_s, Enchantments.field_185309_u, Enchantments.field_185310_v, Enchantments.field_185311_w, Enchantments.field_185312_x});
    public static final List<Enchantment> SWORD_ENCHANTMENTS = PlaceboUtil.asList((Object[])new Enchantment[]{Enchantments.field_185302_k, Enchantments.field_185303_l, Enchantments.field_180312_n, Enchantments.field_180313_o, Enchantments.field_77334_n, Enchantments.field_185304_p});
    public static final List<Enchantment> TOOL_ENCHANTMENTS = PlaceboUtil.asList((Object[])new Enchantment[]{Enchantments.field_185305_q, Enchantments.field_185306_r, Enchantments.field_185307_s, Enchantments.field_185308_t});
    public static final List<Enchantment> ARMOR_ENCHANTMENTS = PlaceboUtil.asList((Object[])new Enchantment[]{Enchantments.field_180310_c, Enchantments.field_185297_d, Enchantments.field_180309_e, Enchantments.field_185297_d, Enchantments.field_185297_d, Enchantments.field_185298_f, Enchantments.field_185299_g, Enchantments.field_92091_k, Enchantments.field_185307_s});
    public static final ArmorSet CHAIN_GEAR = new ArmorSet(0, Items.field_151052_q, Items.field_185159_cQ, Items.field_151029_X, Items.field_151022_W, Items.field_151023_V, Items.field_151020_U).addExtraMains(Items.field_151049_t, Items.field_151051_r, Items.field_151050_s);
    public static final ArmorSet GOLD_GEAR = new ArmorSet(1, Items.field_151010_B, Items.field_185159_cQ, Items.field_151151_aj, Items.field_151149_ai, Items.field_151171_ah, Items.field_151169_ag).addExtraMains(Items.field_151006_E, Items.field_151011_C, Items.field_151005_D);
    public static final ArmorSet IRON_GEAR = new ArmorSet(2, Items.field_151040_l, Items.field_185159_cQ, Items.field_151167_ab, Items.field_151165_aa, Items.field_151030_Z, Items.field_151028_Y).addExtraMains(Items.field_151036_c, Items.field_151037_a, Items.field_151035_b);
    public static final ArmorSet DIAMOND_GEAR = new ArmorSet(3, Items.field_151048_u, Items.field_185159_cQ, Items.field_151175_af, Items.field_151173_ae, Items.field_151163_ad, Items.field_151161_ac).addExtraMains(Items.field_151056_x, Items.field_151047_v, Items.field_151046_w);
    public static final Predicate<Goal> IS_VILLAGER_ATTACK;
    protected final EntityType<?> entityEntry;
    protected AxisAlignedBB entityAABB;

    public BossItem(int weight, ResourceLocation entity) {
        super(weight);
        this.entityEntry = (EntityType)ForgeRegistries.ENTITIES.getValue(entity);
        Preconditions.checkNotNull(this.entityEntry, (Object)("Invalid BossItem (not an entity) created with reloc: " + entity));
    }

    public AxisAlignedBB getAABB(IWorld world) {
        if (this.entityAABB == null) {
            this.entityAABB = this.entityEntry.func_200721_a(world.func_201672_e()).func_70046_E();
        }
        if (this.entityAABB == null) {
            this.entityAABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        return this.entityAABB;
    }

    @Override
    public void place(IWorld world, BlockPos pos) {
        this.place(world, pos, world.func_201674_k());
    }

    public void place(IWorld world, BlockPos pos, Random rand) {
        MobEntity entity = (MobEntity)this.entityEntry.func_200721_a(world.func_201672_e());
        BossItem.initBoss(rand, entity);
        entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        world.func_217376_c((Entity)entity);
        entity.field_70714_bg.field_220892_d.removeIf(IS_VILLAGER_ATTACK);
        entity.func_110163_bv();
        for (BlockPos p : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, -1, -2), (BlockPos)pos.func_177982_a(2, 1, 2))) {
            world.func_180501_a(p, Blocks.field_150350_a.func_176223_P(), 2);
        }
        for (BlockPos p : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, -2, -2), (BlockPos)pos.func_177982_a(2, -2, 2))) {
            world.func_180501_a(p, Blocks.field_180395_cM.func_176223_P(), 2);
        }
        entity.getPersistentData().func_74757_a("apoth_boss", true);
        WorldGenerator.debugLog(pos, "Boss " + entity.func_200200_C_().func_150261_e());
    }

    public static void initBoss(Random random, MobEntity entity) {
        int duration;
        int n = duration = entity instanceof CreeperEntity ? 6000 : Integer.MAX_VALUE;
        if (DeadlyConfig.bossRegenLevel > 0) {
            entity.func_195064_c(new EffectInstance(Effects.field_76428_l, duration, DeadlyConfig.bossRegenLevel));
        }
        if (DeadlyConfig.bossResistLevel > 0) {
            entity.func_195064_c(new EffectInstance(Effects.field_76429_m, duration, DeadlyConfig.bossResistLevel));
        }
        if (DeadlyConfig.bossFireRes) {
            entity.func_195064_c(new EffectInstance(Effects.field_76426_n, duration));
        }
        if (DeadlyConfig.bossWaterBreathing) {
            entity.func_195064_c(new EffectInstance(Effects.field_76427_o, duration));
        }
        AttributeHelper.addToBase((LivingEntity)entity, (IAttribute)SharedMonsterAttributes.field_111264_e, (String)"boss_damage_bonus", (double)DeadlyConfig.bossDamageBonus);
        AttributeHelper.multiplyFinal((LivingEntity)entity, (IAttribute)SharedMonsterAttributes.field_111267_a, (String)"boss_health_mult", (double)(DeadlyConfig.bossHealthMultiplier - 1.0f));
        AttributeHelper.max((LivingEntity)entity, (IAttribute)SharedMonsterAttributes.field_111266_c, (String)"boss_knockback_resist", (double)DeadlyConfig.bossKnockbackResist);
        AttributeHelper.multiplyFinal((LivingEntity)entity, (IAttribute)SharedMonsterAttributes.field_111263_d, (String)"boss_speed_mult", (double)(DeadlyConfig.bossSpeedMultiplier - 1.0f));
        entity.func_70606_j(entity.func_110138_aP());
        String name = NameHelper.setEntityName(random, (LivingEntity)entity);
        entity.func_110163_bv();
        int level = 0;
        for (int i = 0; i < ArmorSet.SORTED_SETS.size() - 1; ++i) {
            if (!(random.nextDouble() < (double)DeadlyConfig.bossLevelUpChance)) continue;
            ++level;
        }
        ArmorSet.SORTED_SETS.get(level).apply((LivingEntity)entity);
        if (entity instanceof SkeletonEntity) {
            entity.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151031_f));
        }
        int guaranteed = random.nextInt(6);
        ItemStack stack = entity.func_184582_a(EquipmentSlotType.values()[guaranteed]);
        while (guaranteed == 1 || stack.func_190926_b()) {
            guaranteed = random.nextInt(6);
            stack = entity.func_184582_a(EquipmentSlotType.values()[guaranteed]);
        }
        for (EquipmentSlotType s : EquipmentSlotType.values()) {
            if (s.ordinal() == guaranteed) {
                entity.func_184642_a(s, 2.0f);
            } else {
                entity.func_184642_a(s, ThreadLocalRandom.current().nextFloat());
            }
            ItemStack enchantedItem = stack;
            if (s.ordinal() == guaranteed) {
                List<Enchantment> enchants = EquipmentType.getTypeForStack(stack).getEnchants();
                Enchantment enchantment = enchants.get(random.nextInt(enchants.size()));
                if (enchants.stream().anyMatch(e -> e.func_92089_a(enchantedItem))) {
                    while (!enchantment.func_92089_a(stack)) {
                        enchantment = enchants.get(random.nextInt(enchants.size()));
                    }
                }
                NameHelper.setItemName(random, stack, name, enchantment);
                for (int i = 0; i < 5; ++i) {
                    BossItem.addSingleEnchantment(stack, random, 28 + (Apotheosis.enableEnch ? 10 : 3) * i, true);
                }
                BossItem.addSingleEnchantment(stack, random, Apotheosis.enableEnch ? 150 : 60, true);
                HashMap enchMap = new HashMap();
                for (Map.Entry e2 : EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet()) {
                    enchMap.put(e2.getKey(), Math.min(EnchHooks.getMaxLevel((Enchantment)e2.getKey()), (Integer)e2.getValue() + random.nextInt(2)));
                }
                EnchantmentHelper.func_82782_a(enchMap, (ItemStack)stack);
                continue;
            }
            if (!(random.nextDouble() < (double)DeadlyConfig.bossEnchantChance)) continue;
            EnchantmentHelper.func_77504_a((Random)random, (ItemStack)stack, (int)(30 + random.nextInt(Apotheosis.enableEnch ? 50 : 25)), (boolean)true);
        }
        if (POTIONS.isEmpty()) {
            BossItem.initPotions();
        }
        if (random.nextDouble() < (double)DeadlyConfig.bossPotionChance) {
            entity.func_195064_c(new EffectInstance(POTIONS.get(random.nextInt(POTIONS.size())), duration, random.nextInt(3) + 1));
        }
    }

    public static void addSingleEnchantment(ItemStack stack, Random rand, int level, boolean treasure) {
        List datas = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)stack, (int)level, (boolean)treasure);
        if (datas.isEmpty()) {
            return;
        }
        EnchantmentData d = (EnchantmentData)datas.get(rand.nextInt(datas.size()));
        stack.func_77966_a(d.field_76302_b, d.field_76303_c);
    }

    public static void initPotions() {
        for (Effect p2 : ForgeRegistries.POTIONS) {
            if (!p2.func_188408_i() || p2.func_76403_b()) continue;
            POTIONS.add(p2);
        }
        POTIONS.removeIf(p -> DeadlyConfig.BLACKLISTED_POTIONS.contains(p.getRegistryName()));
    }

    static {
        ArmorSet.LEVEL_TO_SETS.put(0, CHAIN_GEAR);
        ArmorSet.LEVEL_TO_SETS.put(1, GOLD_GEAR);
        ArmorSet.LEVEL_TO_SETS.put(2, IRON_GEAR);
        ArmorSet.LEVEL_TO_SETS.put(3, DIAMOND_GEAR);
        IS_VILLAGER_ATTACK = a -> a instanceof NearestAttackableTargetGoal && ((NearestAttackableTargetGoal)a).field_75307_b == VillagerEntity.class;
    }

    public static enum EquipmentType {
        SWORD(SWORD_ENCHANTMENTS),
        BOW(BOW_ENCHANTMENTS),
        TOOL(TOOL_ENCHANTMENTS),
        ARMOR(ARMOR_ENCHANTMENTS);

        final List<Enchantment> enchants;

        private EquipmentType(List<Enchantment> enchants) {
            this.enchants = enchants;
        }

        public List<Enchantment> getEnchants() {
            return this.enchants;
        }

        public static EquipmentType getTypeForStack(ItemStack stack) {
            Item i = stack.func_77973_b();
            if (i instanceof SwordItem) {
                return SWORD;
            }
            if (i instanceof BowItem) {
                return BOW;
            }
            if (i instanceof ArmorItem) {
                return ARMOR;
            }
            return TOOL;
        }
    }
}

