/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.altar.RenderPrismaticAltar;
import shadows.apotheosis.ench.altar.TilePrismaticAltar;
import shadows.apotheosis.ench.anvil.compat.ATCompat;
import shadows.apotheosis.village.fletching.FletchingScreen;
import shadows.apotheosis.village.fletching.arrows.BroadheadArrowEntity;
import shadows.apotheosis.village.fletching.arrows.BroadheadArrowRenderer;
import shadows.apotheosis.village.fletching.arrows.ObsidianArrowEntity;
import shadows.apotheosis.village.fletching.arrows.ObsidianArrowRenderer;

@Mod.EventBusSubscriber(modid="apotheosis", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ApotheosisClient {
    private static final Map<IRegistryDelegate<Enchantment>, List<ITextComponent>> ENCH_TOOLTIPS = new HashMap<IRegistryDelegate<Enchantment>, List<ITextComponent>>();

    public static void tooltips(ItemTooltipEvent e) {
        Item i = e.getItemStack().func_77973_b();
        if (Apotheosis.enableEnch) {
            if (EnchModule.allowWeb && i == Items.field_221672_ax) {
                e.getToolTip().add(new TranslationTextComponent("info.apotheosis.cobweb", new Object[0]));
            } else if (i == ApotheosisObjects.PRISMATIC_WEB) {
                e.getToolTip().add(new TranslationTextComponent("info.apotheosis.prismatic_cobweb", new Object[0]));
            }
        }
        if (i == Items.field_151134_bR) {
            for (Map.Entry<IRegistryDelegate<Enchantment>, List<ITextComponent>> ent : ENCH_TOOLTIPS.entrySet()) {
                if (!ApotheosisClient.onlyHasEnchant(e.getItemStack(), (Enchantment)ent.getKey().get())) continue;
                ent.getValue().forEach(s -> e.getToolTip().add(s));
                return;
            }
        } else if (i == Items.field_221824_dv) {
            e.getToolTip().add(new TranslationTextComponent("info.apotheosis.table", new Object[]{(int)EnchModule.maxNormalPower * 2}));
            e.getToolTip().add(new TranslationTextComponent("info.apotheosis.table2", new Object[]{(int)EnchModule.maxPower * 2}));
        }
    }

    private static boolean onlyHasEnchant(ItemStack book, Enchantment ench) {
        CompoundNBT tag;
        ResourceLocation id;
        Enchantment enchantment;
        ListNBT list = EnchantedBookItem.func_92110_g((ItemStack)book);
        return list.size() == 1 && (enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id = new ResourceLocation((tag = list.func_150305_b(0)).func_74779_i("id")))) == ench;
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent e) {
        ITextComponent masterwork = new TranslationTextComponent("info.apotheosis.masterwork", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN));
        ITextComponent twisted = new TranslationTextComponent("info.apotheosis.twisted", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE));
        ITextComponent corrupted = new TranslationTextComponent("info.apotheosis.corrupted", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED));
        if (Apotheosis.enchTooltips) {
            if (Apotheosis.enableSpawner) {
                ApotheosisClient.registerTooltip(ApotheosisObjects.CAPTURING, "enchantment.apotheosis.capturing.desc");
            }
            if (Apotheosis.enablePotion) {
                ApotheosisClient.registerTooltip(ApotheosisObjects.TRUE_INFINITY, masterwork, "", "enchantment.apotheosis.true_infinity.desc");
            }
            if (Apotheosis.enableEnch) {
                ApotheosisClient.registerTooltip(ApotheosisObjects.HELL_INFUSION, masterwork, "", "enchantment.apotheosis.hell_infusion.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.MOUNTED_STRIKE, "enchantment.apotheosis.mounted_strike.desc");
                ApotheosisClient.registerTooltip((Enchantment)ApotheosisObjects.DEPTH_MINER, twisted, "", "enchantment.apotheosis.depth_miner.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.STABLE_FOOTING, "enchantment.apotheosis.stable_footing.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.SCAVENGER, masterwork, "", "enchantment.apotheosis.scavenger.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.LIFE_MENDING, corrupted, "", "enchantment.apotheosis.life_mending.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.ICY_THORNS, "enchantment.apotheosis.icy_thorns.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.TEMPTING, "enchantment.apotheosis.tempting.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.SHIELD_BASH, "enchantment.apotheosis.shield_bash.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.REFLECTIVE, "enchantment.apotheosis.reflective.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.BERSERK, corrupted, "", "enchantment.apotheosis.berserk.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.KNOWLEDGE, masterwork, "", "enchantment.apotheosis.knowledge.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.SPLITTING, "enchantment.apotheosis.splitting.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.NATURES_BLESSING, "enchantment.apotheosis.natures_blessing.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.REBOUNDING, "enchantment.apotheosis.rebounding.desc");
                ApotheosisClient.registerTooltip(ApotheosisObjects.MAGIC_PROTECTION, twisted, "", "enchantment.apotheosis.magic_protection.desc");
            }
        } else {
            if (Apotheosis.enablePotion) {
                ApotheosisClient.registerTooltip(ApotheosisObjects.TRUE_INFINITY, masterwork);
            }
            if (Apotheosis.enableEnch) {
                ApotheosisClient.registerTooltip(ApotheosisObjects.HELL_INFUSION, masterwork);
                ApotheosisClient.registerTooltip((Enchantment)ApotheosisObjects.DEPTH_MINER, twisted);
                ApotheosisClient.registerTooltip(ApotheosisObjects.SCAVENGER, masterwork);
                ApotheosisClient.registerTooltip(ApotheosisObjects.LIFE_MENDING, corrupted);
                ApotheosisClient.registerTooltip(ApotheosisObjects.BERSERK, corrupted);
                ApotheosisClient.registerTooltip(ApotheosisObjects.KNOWLEDGE, masterwork);
                ApotheosisClient.registerTooltip(ApotheosisObjects.MAGIC_PROTECTION, twisted);
            }
        }
        if (Apotheosis.enableEnch) {
            ClientRegistry.bindTileEntitySpecialRenderer(TilePrismaticAltar.class, (TileEntityRenderer)new RenderPrismaticAltar());
        }
        MinecraftForge.EVENT_BUS.addListener(ApotheosisClient::tooltips);
        if (ModList.get().isLoaded("anviltweaks")) {
            ATCompat.tesr();
        }
        if (Apotheosis.enableVillager) {
            DeferredWorkQueue.runLater(() -> {
                ScreenManager.func_216911_a(ApotheosisObjects.FLETCHING, FletchingScreen::new);
                EntityRendererManager mgr = Minecraft.func_71410_x().func_175598_ae();
                mgr.func_217782_a(ObsidianArrowEntity.class, (EntityRenderer)new ObsidianArrowRenderer(mgr));
                mgr.func_217782_a(BroadheadArrowEntity.class, (EntityRenderer)new BroadheadArrowRenderer(mgr));
            });
        }
    }

    public static void registerTooltip(Enchantment e, Object ... keys) {
        List tips = ENCH_TOOLTIPS.computeIfAbsent((IRegistryDelegate<Enchantment>)e.delegate, d -> new ArrayList());
        for (Object s : keys) {
            if (s instanceof ITextComponent) {
                tips.add((ITextComponent)s);
                continue;
            }
            if (!(s instanceof String)) continue;
            tips.add(new TranslationTextComponent((String)s, new Object[0]));
        }
    }
}

