/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.base.EnchantBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantExcavation
extends EnchantBase {
    int[] levelToMaxBreak = new int[]{0, 8, 14, 36};

    public EnchantExcavation(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
    }

    public int func_77325_b() {
        return 3;
    }

    private int getHarvestMax(int level) {
        return this.levelToMaxBreak[level];
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        IWorld world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        if (player.field_184622_au == null) {
            return;
        }
        BlockPos pos = event.getPos();
        Block block = event.getState().func_177230_c();
        ItemStack stackHarvestingWith = player.func_184586_b(player.field_184622_au);
        int level = this.getCurrentLevelTool(stackHarvestingWith);
        if (level <= 0) {
            return;
        }
        boolean isAnySingleOk = false;
        for (ToolType type : stackHarvestingWith.func_77973_b().getToolTypes(stackHarvestingWith)) {
            if (!block.isToolEffective(world.func_180495_p(pos), type)) continue;
            isAnySingleOk = true;
        }
        if (isAnySingleOk) {
            this.harvestSurrounding((World)world, player, pos, block, 1, level, player.field_184622_au);
        }
    }

    private int harvestSurrounding(World world, PlayerEntity player, BlockPos posIn, Block block, int totalBroken, int level, Hand swingingHand) {
        if (totalBroken >= this.getHarvestMax(level) || player.func_184586_b(player.field_184622_au).func_190926_b()) {
            return totalBroken;
        }
        List<BlockPos> theFuture = this.getMatchingSurrounding(world, posIn, block);
        ArrayList<BlockPos> wasHarvested = new ArrayList<BlockPos>();
        for (BlockPos targetPos : theFuture) {
            BlockState targetState = world.func_180495_p(targetPos);
            if (world.func_175623_d(targetPos) || !player.func_184823_b(targetState) || totalBroken >= this.getHarvestMax(level) || player.func_184586_b(player.field_184622_au).func_190926_b()) continue;
            block.func_180657_a(world, player, targetPos, targetState, null, player.func_184586_b(swingingHand));
            world.func_175655_b(targetPos, false);
            wasHarvested.add(targetPos);
            player.func_184586_b(player.field_184622_au).func_96631_a(1, world.field_73012_v, null);
            ++totalBroken;
        }
        for (BlockPos targetPos : theFuture) {
            if (totalBroken >= this.getHarvestMax(level) || player.func_184586_b(player.field_184622_au).func_190926_b()) break;
            totalBroken += this.harvestSurrounding(world, player, targetPos, block, totalBroken, level, swingingHand);
        }
        return totalBroken;
    }

    private List<BlockPos> getMatchingSurrounding(World world, BlockPos start, Block blockIn) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        List<Direction> targetFaces = Arrays.asList(Direction.values());
        Collections.shuffle(targetFaces);
        for (Direction fac : targetFaces) {
            if (world.func_180495_p(start.func_177972_a(fac)).func_177230_c() != blockIn) continue;
            list.add(start.func_177972_a(fac));
        }
        return list;
    }
}

