/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.power;

import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.tile.tier3.TileEngine;
import com.bluepowermod.util.AABBUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockEngine
extends BlockContainerBase {
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final BooleanProperty GEAR = BooleanProperty.func_177716_a((String)"gear");
    public static final BooleanProperty GLIDER = BooleanProperty.func_177716_a((String)"glider");
    public static final EnumProperty<Direction> FACING = EnumProperty.func_177709_a((String)"facing", Direction.class);

    public BlockEngine() {
        super(Material.field_151573_f, TileEngine.class);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)GEAR, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)GLIDER, (Comparable)Boolean.valueOf(false))).func_206870_a(FACING, (Comparable)Direction.DOWN));
        this.setRegistryName("bluepower", "engine");
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ACTIVE, GEAR, GLIDER, FACING});
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return AABBUtils.rotate(Block.func_208617_a((double)0.01, (double)0.0, (double)0.01, (double)15.99f, (double)10.0, (double)15.99f), ((Direction)blockState.func_177229_b(FACING)).func_176734_d());
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity player, ItemStack iStack) {
        if (world.func_175625_s(pos) instanceof TileEngine) {
            Direction facing = player.field_70125_A > 45.0f ? Direction.DOWN : (player.field_70125_A < -45.0f ? Direction.UP : player.func_174811_aO().func_176734_d());
            TileEngine tile = (TileEngine)world.func_175625_s(pos);
            if (tile != null) {
                tile.setOrientation(facing);
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a(FACING, (Comparable)facing), 2);
        }
    }

    @Override
    public boolean func_220051_a(BlockState blockState, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        Item item;
        if (!player.field_71071_by.func_70448_g().func_190926_b() && (item = player.field_71071_by.func_70448_g().func_77973_b()) == BPItems.screwdriver) {
            return true;
        }
        return super.func_220051_a(blockState, world, pos, player, hand, rayTraceResult);
    }

    @Override
    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }
}

