/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.gates;

import com.bluepowermod.block.BlockBase;
import com.bluepowermod.helper.DirectionHelper;
import com.bluepowermod.reference.Refs;
import com.bluepowermod.util.AABBUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockGateBase
extends BlockBase {
    private final String name;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final IntegerProperty ROTATION = IntegerProperty.func_177719_a((String)"rotation", (int)0, (int)3);
    public static final BooleanProperty POWERED_FRONT = BooleanProperty.func_177716_a((String)"powered_front");
    public static final BooleanProperty POWERED_BACK = BooleanProperty.func_177716_a((String)"powered_back");
    public static final BooleanProperty POWERED_LEFT = BooleanProperty.func_177716_a((String)"powered_left");
    public static final BooleanProperty POWERED_RIGHT = BooleanProperty.func_177716_a((String)"powered_right");

    public BlockGateBase(String name) {
        super(Material.field_151571_B);
        this.name = name;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.UP)).func_206870_a((IProperty)POWERED_BACK, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POWERED_FRONT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POWERED_LEFT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POWERED_RIGHT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)ROTATION, (Comparable)Integer.valueOf(0)));
        this.setWIP(true);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, ROTATION, POWERED_BACK, POWERED_FRONT, POWERED_LEFT, POWERED_RIGHT});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABBUtils.rotate(Refs.GATE_AABB, (Direction)state.func_177229_b((IProperty)FACING));
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return state.func_177229_b((IProperty)FACING) != side && ((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d() != side;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction face = context.func_196000_l();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)ROTATION, (Comparable)Integer.valueOf(context.func_195992_f().func_176734_d().func_176736_b()))).func_206870_a((IProperty)FACING, (Comparable)face);
    }

    public BlockState getStateForPlacement(BlockState state, Direction facing, BlockState state2, IWorld world, BlockPos pos1, BlockPos pos2, Hand hand) {
        Map<String, Byte> map = this.getSidePower((IBlockReader)world, state, pos1);
        return (BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(state, facing, state2, world, pos1, pos2, hand).func_206870_a((IProperty)POWERED_FRONT, (Comparable)Boolean.valueOf(map.get("front") > 0))).func_206870_a((IProperty)POWERED_BACK, (Comparable)Boolean.valueOf(map.get("back") > 0))).func_206870_a((IProperty)POWERED_LEFT, (Comparable)Boolean.valueOf(map.get("left") > 0))).func_206870_a((IProperty)POWERED_RIGHT, (Comparable)Boolean.valueOf(map.get("right") > 0));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        Map<String, Byte> map = this.getSidePower((IBlockReader)world, state, pos);
        world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)POWERED_FRONT, (Comparable)Boolean.valueOf(map.get("front") > 0))).func_206870_a((IProperty)POWERED_BACK, (Comparable)Boolean.valueOf(map.get("back") > 0))).func_206870_a((IProperty)POWERED_LEFT, (Comparable)Boolean.valueOf(map.get("left") > 0))).func_206870_a((IProperty)POWERED_RIGHT, (Comparable)Boolean.valueOf(map.get("right") > 0)));
    }

    public boolean func_149744_f(BlockState p_149744_1_) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        Direction[] dirs = DirectionHelper.ArrayFromDirection((Direction)blockState.func_177229_b((IProperty)FACING));
        if (side == dirs[(Integer)blockState.func_177229_b((IProperty)ROTATION)]) {
            Map<String, Byte> map = this.getSidePower(blockAccess, blockState, pos);
            return map.get("front").byteValue();
        }
        return 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        Direction[] dirs = DirectionHelper.ArrayFromDirection((Direction)blockState.func_177229_b((IProperty)FACING));
        if (side == dirs[(Integer)blockState.func_177229_b((IProperty)ROTATION)]) {
            Map<String, Byte> map = this.getSidePower(blockAccess, blockState, pos);
            return map.get("front").byteValue();
        }
        return 0;
    }

    private Map<String, Byte> getSidePower(IBlockReader worldIn, BlockState state, BlockPos pos) {
        HashMap<String, Byte> map = new HashMap<String, Byte>();
        Direction[] dirs = DirectionHelper.ArrayFromDirection((Direction)state.func_177229_b((IProperty)FACING));
        Direction side_left = dirs[(Integer)state.func_177229_b((IProperty)ROTATION) == 3 ? 0 : (Integer)state.func_177229_b((IProperty)ROTATION) + 1];
        Direction side_right = side_left.func_176734_d();
        Direction side_back = dirs[(Integer)state.func_177229_b((IProperty)ROTATION)];
        BlockPos pos_left = pos.func_177972_a(side_left);
        BlockPos pos_right = pos.func_177972_a(side_right);
        BlockPos pos_back = pos.func_177972_a(side_back);
        BlockState state_left = worldIn.func_180495_p(pos_left);
        BlockState state_right = worldIn.func_180495_p(pos_right);
        BlockState state_back = worldIn.func_180495_p(pos_back);
        byte left = (byte)state_left.func_185911_a(worldIn, pos_left, side_right);
        byte right = (byte)state_right.func_185911_a(worldIn, pos_right, side_left);
        byte back = (byte)state_back.func_185911_a(worldIn, pos_back, side_back.func_176734_d());
        if (state_left.func_177230_c() instanceof RedstoneWireBlock) {
            left = ((Integer)state_left.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O)).byteValue();
        }
        if (state_right.func_177230_c() instanceof RedstoneWireBlock) {
            right = ((Integer)state_right.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O)).byteValue();
        }
        if (state_back.func_177230_c() instanceof RedstoneWireBlock) {
            back = ((Integer)state_back.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O)).byteValue();
        }
        map.put("left", left);
        map.put("right", right);
        map.put("back", back);
        map.put("front", this.computeRedstone(back, left, right));
        return map;
    }

    public byte computeRedstone(byte back, byte left, byte right) {
        if (left > 0 && right > 0) {
            return (byte)(back > 0 ? 16 : 0);
        }
        return 0;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, bool);
        if (!world.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_215686_e((IBlockReader)world, pos.func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d()))) {
            world.func_175655_b(pos, true);
            return;
        }
        Map<String, Byte> map = this.getSidePower((IBlockReader)world, state, pos);
        world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)POWERED_FRONT, (Comparable)Boolean.valueOf(map.get("front") > 0))).func_206870_a((IProperty)POWERED_BACK, (Comparable)Boolean.valueOf(map.get("back") > 0))).func_206870_a((IProperty)POWERED_LEFT, (Comparable)Boolean.valueOf(map.get("left") > 0))).func_206870_a((IProperty)POWERED_RIGHT, (Comparable)Boolean.valueOf(map.get("right") > 0)));
    }
}

