/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import lumien.randomthings.client.util.RenderUtils;
import lumien.randomthings.item.DiviningRodItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class DiviningRodRenderer {
    public static DiviningRodRenderer INSTANCE;
    LinkedHashSet<BlockPos> positionsToCheck = new LinkedHashSet();
    List<Indicator> indicators = new ArrayList<Indicator>();
    HashMap<Block, Color> blockColorMap;
    int modX;
    int modY;
    int modZ;

    public boolean shouldGlow(DiviningRodItem rodType) {
        return !this.indicators.isEmpty() && this.indicators.stream().anyMatch(i -> i.type == rodType);
    }

    public void render() {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        ActiveRenderInfo ari = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vec3d pos = ari.func_216785_c();
        double playerX = pos.func_82615_a();
        double playerY = pos.func_82617_b();
        double playerZ = pos.func_82616_c();
        GlStateManager.disableDepthTest();
        RenderUtils.enableDefaultBlending();
        GlStateManager.translated((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        for (Indicator indicator : this.indicators) {
            float size = (1.0f - (float)indicator.duration / 160.0f) * 0.2f + 0.1f;
            Color c = indicator.color;
            RenderUtils.drawCube((float)((double)indicator.target.func_177958_n() + 0.5 - (double)(size / 2.0f)), (float)((double)indicator.target.func_177956_o() + 0.5 - (double)(size / 2.0f)), (float)((double)indicator.target.func_177952_p() + 0.5 - (double)(size / 2.0f)), size, c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }
        GlStateManager.translated((double)playerX, (double)playerY, (double)playerZ);
        GlStateManager.enableDepthTest();
    }

    public void tick() {
        World world;
        Iterator<Indicator> indicatorIterator = this.indicators.iterator();
        while (indicatorIterator.hasNext()) {
            Indicator i = indicatorIterator.next();
            --i.duration;
            if (i.duration != 0) continue;
            indicatorIterator.remove();
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (world = player.field_70170_p) != null) {
            ItemStack main = player.func_184614_ca();
            ItemStack off = player.func_184592_cb();
            ItemStack rod = ItemStack.field_190927_a;
            if (!main.func_190926_b() && main.func_77973_b() instanceof DiviningRodItem) {
                rod = main;
            } else if (!off.func_190926_b() && off.func_77973_b() instanceof DiviningRodItem) {
                rod = off;
            }
            if (!rod.func_190926_b()) {
                DiviningRodItem type = (DiviningRodItem)rod.func_77973_b();
                BlockPos playerPos = player.func_180425_c();
                for (int i = 0; i < 60; ++i) {
                    int matchIndex;
                    ++this.modX;
                    if (this.modX == 6) {
                        this.modX = -5;
                        ++this.modZ;
                        if (this.modZ == 6) {
                            this.modZ = -5;
                            ++this.modY;
                            if (this.modY == 6) {
                                this.modY = -5;
                            }
                        }
                    }
                    BlockPos target = playerPos.func_177982_a(this.modX, this.modY, this.modZ);
                    BlockState blockState = world.func_180495_p(target);
                    if (!world.isAreaLoaded(target, 0) || (matchIndex = type.matches(blockState)) == -1) continue;
                    Indicator indicator = new Indicator(target, 160, type.getColor(matchIndex), type);
                    this.indicators.add(indicator);
                }
            }
        }
    }

    public static DiviningRodRenderer get() {
        if (INSTANCE == null) {
            INSTANCE = new DiviningRodRenderer();
        }
        return INSTANCE;
    }

    private static class Indicator {
        BlockPos target;
        int duration;
        Color color;
        DiviningRodItem type;

        public Indicator(BlockPos target, int duration, Color color, DiviningRodItem type) {
            this.target = target;
            this.duration = duration;
            this.color = color;
            this.type = type;
        }
    }
}

