/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings;

import lumien.randomthings.block.FertilizedDirtBlock;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.client.renderer.DiviningRodRenderer;
import lumien.randomthings.client.screen.ModScreens;
import lumien.randomthings.container.ModContainerTypes;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.network.RTPacketHandler;
import lumien.randomthings.tileentity.ModTileEntityTypes;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="randomthings")
public class RandomThings {
    private static final Logger LOGGER = LogManager.getLogger();
    public static RandomThings INSTANCE;

    public RandomThings() {
        INSTANCE = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupCommon);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(event -> {
            BlockPos pos;
            ItemUseContext context = event.getContext();
            World world = context.func_195991_k();
            BlockState state = world.func_180495_p(pos = context.func_195995_a());
            if (state.func_177230_c() == ModBlocks.FERTILIZED_DIRT && !((Boolean)state.func_177229_b((IProperty)FertilizedDirtBlock.TILLED)).booleanValue()) {
                event.setResult(Event.Result.ALLOW);
                world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)FertilizedDirtBlock.TILLED, (Comparable)Boolean.valueOf(true)));
                PlayerEntity playerentity = context.func_195999_j();
                world.func_184133_a(playerentity, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                DiviningRodRenderer.get().tick();
            }
        });
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        RTPacketHandler.register();
    }

    private void setupClient(FMLClientSetupEvent event) {
        ModScreens.register();
        MinecraftForge.EVENT_BUS.addListener(rwl -> DiviningRodRenderer.get().render());
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            ModBlocks.registerBlocks(blockRegistryEvent);
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            ModItems.initItemGroup();
            ModItems.registerItems(itemRegistryEvent);
        }

        @SubscribeEvent
        public static void onTileEntityTypesRegistry(RegistryEvent.Register<TileEntityType<?>> tileEntityTypeRegistryEvent) {
            ModTileEntityTypes.registerTypes(tileEntityTypeRegistryEvent);
        }

        @SubscribeEvent
        public static void onContainerTypesRegistry(RegistryEvent.Register<ContainerType<?>> containerTypeRegistryEvent) {
            ModContainerTypes.registerContainerTypes(containerTypeRegistryEvent);
        }
    }
}

