/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTToSNBTConverter
implements IDataProvider {
    private static final Logger field_200418_a = LogManager.getLogger();
    private final DataGenerator field_200419_b;

    public NBTToSNBTConverter(DataGenerator dataGenerator) {
        this.field_200419_b = dataGenerator;
    }

    @Override
    public void func_200398_a(DirectoryCache directoryCache) throws IOException {
        Path path2 = this.field_200419_b.func_200391_b();
        for (Path path4 : this.field_200419_b.func_200389_a()) {
            Files.walk(path4, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".nbt")).forEach(path3 -> this.func_200414_a((Path)path3, this.func_200417_a(path4, (Path)path3), path2));
        }
    }

    @Override
    public String func_200397_b() {
        return "NBT to SNBT";
    }

    private String func_200417_a(Path path, Path path2) {
        String string = path.relativize(path2).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".nbt".length());
    }

    private void func_200414_a(Path path, String string, Path path2) {
        try {
            CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a(Files.newInputStream(path, new OpenOption[0]));
            ITextComponent \u26032 = compoundNBT.func_199850_a("    ", 0);
            String \u26033 = \u26032.getString() + "\n";
            Path \u26034 = path2.resolve(string + ".snbt");
            Files.createDirectories(\u26034.getParent(), new FileAttribute[0]);
            try (BufferedWriter \u26035 = Files.newBufferedWriter(\u26034, new OpenOption[0]);){
                \u26035.write(\u26033);
            }
            field_200418_a.info("Converted {} from NBT to SNBT", (Object)string);
        }
        catch (IOException iOException) {
            field_200418_a.error("Couldn't convert {} from NBT to SNBT at {}", (Object)string, (Object)path, (Object)iOException);
        }
    }
}

