/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.api.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.ItemStackHandler;

public class CAStacksBase
extends ItemStackHandler {
    protected boolean[] isSkinArmor;

    public CAStacksBase() {
        this(4);
    }

    public CAStacksBase(int size) {
        super(size);
        this.isSkinArmor = new boolean[this.stacks.size()];
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size());
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            if (itemTags.func_74764_b("id")) {
                this.stacks.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTags));
            }
            if (!itemTags.func_74764_b("isSkinArmor")) continue;
            this.isSkinArmor[slot] = itemTags.func_74767_n("isSkinArmor");
        }
        this.onLoad();
    }

    public boolean isSkinArmor(int slot) {
        this.validateSlotIndex(slot);
        return this.isSkinArmor[slot];
    }

    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b() && !this.isSkinArmor[i]) continue;
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74768_a("Slot", i);
            if (!((ItemStack)this.stacks.get(i)).func_190926_b()) {
                ((ItemStack)this.stacks.get(i)).func_77955_b(itemTag);
            }
            if (this.isSkinArmor[i]) {
                itemTag.func_74757_a("isSkinArmor", true);
            }
            nbtTagList.add((Object)itemTag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.size());
        return nbt;
    }

    public void setSize(int size) {
        super.setSize(size);
        this.isSkinArmor = new boolean[this.stacks.size()];
    }

    public void setSkinArmor(int slot, boolean enabled) {
        this.validateSlotIndex(slot);
        if (this.isSkinArmor[slot] == enabled) {
            return;
        }
        this.isSkinArmor[slot] = enabled;
        this.onContentsChanged(slot);
    }
}

