/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.gui.addon;

import com.hrznstudio.titanium.api.client.assets.types.ITankAsset;
import com.hrznstudio.titanium.block.tile.fluid.PosFluidTank;
import com.hrznstudio.titanium.client.gui.addon.BasicGuiAddon;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class TankGuiAddon
extends BasicGuiAddon {
    private PosFluidTank tank;
    private ITankAsset asset;

    public TankGuiAddon(PosFluidTank tank) {
        super(tank.getPosX(), tank.getPosY());
        this.tank = tank;
    }

    @Override
    public void drawGuiContainerBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.asset = (ITankAsset)IAssetProvider.getAsset(provider, this.tank.getTankType().getAssetType());
        Rectangle area = this.asset.getArea();
        if (!this.tank.getFluid().isEmpty()) {
            FluidStack stack = this.tank.getFluid();
            int stored = this.tank.getFluidAmount();
            int capacity = this.tank.getCapacity();
            int topBottomPadding = this.asset.getFluidRenderPadding(Direction.UP) + this.asset.getFluidRenderPadding(Direction.DOWN);
            int offset = stored * (area.height - topBottomPadding) / capacity;
            ResourceLocation flowing = stack.getFluid().getAttributes().getStill(stack);
            if (flowing != null) {
                TextureAtlasSprite sprite = screen.getMinecraft().func_147117_R().func_110572_b(flowing.toString());
                if (sprite == null) {
                    sprite = MissingTextureSprite.func_217790_a();
                }
                screen.getMinecraft().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                Color color = new Color(stack.getFluid().getAttributes().getColor());
                GlStateManager.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
                GlStateManager.enableBlend();
                Screen.blit((int)(this.getPosX() + guiX + this.asset.getFluidRenderPadding(Direction.WEST)), (int)(this.getPosY() + guiY + this.asset.getFluidRenderPadding(Direction.UP) + (stack.getFluid().getAttributes().isGaseous() ? area.height - topBottomPadding : area.height - topBottomPadding - offset)), (int)0, (int)((int)(area.getWidth() - (double)this.asset.getFluidRenderPadding(Direction.EAST) - (double)this.asset.getFluidRenderPadding(Direction.WEST))), (int)offset, (TextureAtlasSprite)sprite);
                GlStateManager.disableBlend();
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableAlphaTest();
        ITankAsset asset = (ITankAsset)IAssetProvider.getAsset(provider, this.tank.getTankType().getAssetType());
        AssetUtil.drawAsset(screen, asset, this.getPosX(), this.getPosY());
    }

    @Override
    public List<String> getTooltipLines() {
        return Arrays.asList(TextFormatting.GOLD + "Fluid: " + TextFormatting.WHITE + (this.tank.getFluid().isEmpty() ? "Empty" : this.tank.getFluid().getFluid().getAttributes().getTranslationKey(this.tank.getFluid())), TextFormatting.GOLD + "Amount: " + TextFormatting.WHITE + new DecimalFormat().format(this.tank.getFluidAmount()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(this.tank.getCapacity()) + TextFormatting.DARK_AQUA + "mb");
    }

    @Override
    public int getXSize() {
        return this.asset != null ? this.asset.getArea().width : 0;
    }

    @Override
    public int getYSize() {
        return this.asset != null ? this.asset.getArea().height : 0;
    }
}

