/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.TilePowered;
import com.hrznstudio.titanium.block.tile.progress.PosProgressBar;
import com.hrznstudio.titanium.client.gui.addon.EnergyBarGuiAddon;
import com.hrznstudio.titanium.energy.NBTEnergyHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class TileGenerator
extends TilePowered {
    @Save
    private PosProgressBar progressBar;

    public TileGenerator(BlockTileBase blockTileBase) {
        super(blockTileBase);
        this.addGuiAddonFactory(() -> new EnergyBarGuiAddon(10, 20, (IEnergyStorage)this.getEnergyStorage()));
        this.progressBar = this.getProgressBar().setTile(this).setCanIncrease(tileEntity -> true).setIncreaseType(false).setOnStart(() -> {
            this.progressBar.setMaxProgress(this.consumeFuel());
            this.progressBar.setProgress(this.progressBar.getMaxProgress());
            this.markForUpdate();
        }).setCanReset(tileEntity -> this.canStart()).setOnTickWork(() -> this.getEnergyStorage().receiveEnergyForced(this.getEnergyProducedEveryTick()));
        this.addProgressBar(this.progressBar);
    }

    @Override
    protected IFactory<NBTEnergyHandler> getEnergyHandlerFactory() {
        return () -> new NBTEnergyHandler(this, this.getEnergyCapacity(), 0, this.getExtractingEnergy());
    }

    public abstract int consumeFuel();

    public abstract boolean canStart();

    public abstract int getEnergyProducedEveryTick();

    public abstract PosProgressBar getProgressBar();

    public abstract int getEnergyCapacity();

    public abstract int getExtractingEnergy();

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        for (Direction facing : Direction.values()) {
            BlockPos checking = this.field_174879_c.func_177972_a(facing);
            TileEntity checkingTile = this.field_145850_b.func_175625_s(checking);
            if (checkingTile == null) continue;
            checkingTile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()).ifPresent(storage -> {
                int energy = storage.receiveEnergy(Math.min(this.getEnergyStorage().getEnergyStored(), this.getExtractingEnergy()), false);
                if (energy > 0) {
                    this.getEnergyStorage().extractEnergy(energy, false);
                    return;
                }
            });
        }
    }
}

