/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.proxy;

import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.gui.GuiConfig;
import mcjty.theoneprobe.gui.GuiNote;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.keys.KeyBindings;
import mcjty.theoneprobe.keys.KeyInputHandler;
import mcjty.theoneprobe.proxy.IProxy;
import mcjty.theoneprobe.rendering.OverlayRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class ClientProxy
implements IProxy {
    public static boolean ignoreNextGuiClose = false;

    @Override
    public void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
        KeyBindings.init();
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        ModItems.initClient();
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (ignoreNextGuiClose) {
            Screen current = Minecraft.func_71410_x().field_71462_r;
            if (event.getGui() == null && (current instanceof GuiConfig || current instanceof GuiNote)) {
                ignoreNextGuiClose = false;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void renderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        if ((Boolean)Config.holdKeyToMakeVisible.get() != false ? !KeyBindings.toggleVisible.func_151470_d() : (Boolean)Config.isVisible.get() == false) {
            return;
        }
        if (this.hasItemInEitherHand(ModItems.creativeProbe)) {
            OverlayRenderer.renderHUD(ProbeMode.DEBUG, event.getPartialTicks());
        } else {
            switch ((Integer)Config.needsProbe.get()) {
                case 0: 
                case 3: {
                    OverlayRenderer.renderHUD(this.getModeForPlayer(), event.getPartialTicks());
                    break;
                }
                case 1: 
                case 2: {
                    if (!ModItems.hasAProbeSomewhere((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) break;
                    OverlayRenderer.renderHUD(this.getModeForPlayer(), event.getPartialTicks());
                }
            }
        }
    }

    private ProbeMode getModeForPlayer() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (((Boolean)Config.extendedInMain.get()).booleanValue() && this.hasItemInMainHand(ModItems.probe)) {
            return ProbeMode.EXTENDED;
        }
        return player.func_70093_af() ? ProbeMode.EXTENDED : ProbeMode.NORMAL;
    }

    private boolean hasItemInEitherHand(Item item) {
        ItemStack mainHeldItem = Minecraft.func_71410_x().field_71439_g.func_184586_b(Hand.MAIN_HAND);
        ItemStack offHeldItem = Minecraft.func_71410_x().field_71439_g.func_184586_b(Hand.OFF_HAND);
        return mainHeldItem.func_77973_b() == item || offHeldItem.func_77973_b() == item;
    }

    private boolean hasItemInMainHand(Item item) {
        ItemStack mainHeldItem = Minecraft.func_71410_x().field_71439_g.func_184586_b(Hand.MAIN_HAND);
        return mainHeldItem.func_77973_b() == item;
    }
}

