/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.event.DrawerPopulatedEvent;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.StandardDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;

public class TileEntityDrawersStandard
extends TileEntityDrawers {
    @CapabilityInject(value=IDrawerAttributes.class)
    static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = null;
    private static final String[] GUI_IDS = new String[]{null, "storagedrawers:basicDrawers1", "storagedrawers:basicDrawers2", null, "storagedrawers:basicDrawers4"};
    private int capacity = 0;

    public TileEntityDrawersStandard(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public static TileEntityDrawersStandard createEntity(int slotCount) {
        switch (slotCount) {
            case 1: {
                return new Slot1();
            }
            case 2: {
                return new Slot2();
            }
            case 4: {
                return new Slot4();
            }
        }
        return null;
    }

    @Override
    public IDrawerGroup getGroup() {
        return null;
    }

    private class StandardDrawerData
    extends StandardDrawerGroup.DrawerData {
        private int slot;

        public StandardDrawerData(StandardDrawerGroup group, int slot) {
            super(group);
            this.slot = slot;
        }

        @Override
        protected int getStackCapacity() {
            return TileEntityDrawersStandard.this.upgrades().getStorageMultiplier() * TileEntityDrawersStandard.this.getEffectiveDrawerCapacity();
        }

        @Override
        protected void onItemChanged() {
            DrawerPopulatedEvent event = new DrawerPopulatedEvent(this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (TileEntityDrawersStandard.this.func_145831_w() != null && !TileEntityDrawersStandard.this.func_145831_w().field_72995_K) {
                TileEntityDrawersStandard.this.func_70296_d();
                TileEntityDrawersStandard.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (TileEntityDrawersStandard.this.func_145831_w() != null && !TileEntityDrawersStandard.this.func_145831_w().field_72995_K) {
                TileEntityDrawersStandard.this.syncClientCount(this.slot, this.getStoredItemCount());
                TileEntityDrawersStandard.this.func_70296_d();
            }
        }
    }

    private class GroupData
    extends StandardDrawerGroup {
        private final LazyOptional<?> attributesHandler;

        public GroupData(int slotCount) {
            super(slotCount);
            this.attributesHandler = LazyOptional.of(TileEntityDrawersStandard.this::getDrawerAttributes);
        }

        @Override
        @Nonnull
        protected StandardDrawerGroup.DrawerData createDrawer(int slot) {
            return new StandardDrawerData(this, slot);
        }

        @Override
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == DRAWER_ATTRIBUTES_CAPABILITY) {
                return this.attributesHandler.cast();
            }
            return super.getCapability(capability, facing);
        }
    }

    public static class Slot4
    extends TileEntityDrawersStandard {
        private GroupData groupData = new GroupData(4);

        public Slot4() {
            super(ModBlocks.Tile.STANDARD_DRAWERS_4);
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot2
    extends TileEntityDrawersStandard {
        private GroupData groupData = new GroupData(2);

        public Slot2() {
            super(ModBlocks.Tile.STANDARD_DRAWERS_2);
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot1
    extends TileEntityDrawersStandard {
        private GroupData groupData = new GroupData(1);

        public Slot1() {
            super(ModBlocks.Tile.STANDARD_DRAWERS_1);
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }
}

