/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateServerMessage;

public class UpdateClientMessage {
    private BlockPos spawnPos;
    private int range;
    public int ghostlyShapeDuration;
    public int tabletMaxUse;
    public int chanceEnchantedGraveKey;
    public int xpLoss;
    public int chanceLootLostTablet;
    public int cooldownToPray;
    public boolean handlePlayerXp;
    public boolean unbreakableDecorativeGrave;
    public boolean nerfShadowStep;
    public boolean enableEnchantmentShadowStep;
    public boolean enableEnchantmentSoulbound;
    public boolean allowBookOfDisenchantment;
    public boolean allowVoodooPoppet;
    private boolean dateAroundHalloween;
    private boolean isContributor;

    public UpdateClientMessage(BlockPos spawnPos, int range, boolean handlePlayerXp, int ghostlyShapeDuration, int tabletMaxUse, boolean unbreakableDecorativeGrave, int cooldownToPray, boolean nerfShadowStep, boolean enableEnchantmentShadowStep, boolean enableEnchantmentSoulbound, boolean allowBookOfDisenchantment, boolean allowVoodooPoppet, int chanceLootLostTablet, boolean dateAroundHalloween, boolean isContributor, int xpLoss, int chanceEnchantedGraveKey) {
        this.spawnPos = spawnPos;
        this.range = range;
        this.handlePlayerXp = handlePlayerXp;
        this.ghostlyShapeDuration = ghostlyShapeDuration;
        this.tabletMaxUse = tabletMaxUse;
        this.unbreakableDecorativeGrave = unbreakableDecorativeGrave;
        this.cooldownToPray = cooldownToPray;
        this.nerfShadowStep = nerfShadowStep;
        this.enableEnchantmentShadowStep = enableEnchantmentShadowStep;
        this.enableEnchantmentSoulbound = enableEnchantmentSoulbound;
        this.allowBookOfDisenchantment = allowBookOfDisenchantment;
        this.allowVoodooPoppet = allowVoodooPoppet;
        this.chanceLootLostTablet = chanceLootLostTablet;
        this.dateAroundHalloween = dateAroundHalloween;
        this.isContributor = isContributor;
        this.xpLoss = xpLoss;
        this.chanceEnchantedGraveKey = chanceEnchantedGraveKey;
    }

    static UpdateClientMessage fromBytes(PacketBuffer buf) {
        return new UpdateClientMessage(BlockPos.func_218283_e((long)buf.readLong()), buf.readInt(), buf.readBoolean(), buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readInt(), buf.readInt());
    }

    static void toBytes(UpdateClientMessage msg, PacketBuffer buf) {
        buf.writeLong(msg.spawnPos.func_218275_a());
        buf.writeInt(msg.range);
        buf.writeBoolean(msg.handlePlayerXp);
        buf.writeInt(msg.ghostlyShapeDuration);
        buf.writeInt(msg.tabletMaxUse);
        buf.writeBoolean(msg.unbreakableDecorativeGrave);
        buf.writeInt(msg.cooldownToPray);
        buf.writeBoolean(msg.nerfShadowStep);
        buf.writeBoolean(msg.enableEnchantmentShadowStep);
        buf.writeBoolean(msg.enableEnchantmentSoulbound);
        buf.writeBoolean(msg.allowBookOfDisenchantment);
        buf.writeBoolean(msg.allowVoodooPoppet);
        buf.writeInt(msg.chanceLootLostTablet);
        buf.writeBoolean(msg.dateAroundHalloween);
        buf.writeBoolean(msg.isContributor);
        buf.writeInt(msg.xpLoss);
        buf.writeInt(msg.chanceEnchantedGraveKey);
    }

    public static class Handler {
        static void handle(UpdateClientMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ConfigTombstone.handleClientPacket(message);
                SpawnProtectionHandler.getInstance().setSpawnProtection(message.spawnPos, message.range);
                Helper.isHalloween = message.dateAroundHalloween;
                Helper.isContributor = message.isContributor;
                PacketHandler.sendToServer(new UpdateServerMessage((GraveModel)((Object)((Object)ConfigTombstone.client.favoriteGrave.get())), (BlockGraveMarble.MarbleType)((Object)((Object)ConfigTombstone.client.favoriteGraveMarble.get())), (Boolean)ConfigTombstone.client.equipElytraInPriority.get(), (Boolean)ConfigTombstone.client.displayKnowledgeMessage.get(), true));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

