/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemAnkhOfPray
extends ItemGeneric
implements ISoulConsumer {
    public ItemAnkhOfPray() {
        super("ankh_of_pray", ItemAnkhOfPray.getBuilder(true).func_200917_a(1).func_200915_b(10));
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack).func_150255_a(StyleType.MESSAGE_SPECIAL.getStyle());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip(world, stack)) {
            this.addItemDesc(list);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                    if (!this.func_77636_d(stack)) {
                        long cd = (cap.getNextPray() - TimeHelper.worldTicks(player.field_70170_p)) / 20L;
                        if (cd > 0L) {
                            long hour = cd / 3600L;
                            String timeString = "";
                            if (hour > 0L) {
                                cd -= hour * 3600L;
                                timeString = String.format("%02d", hour) + ":";
                            }
                            timeString = timeString + String.format("%02d", cd / 60L) + ":" + String.format("%02d", cd % 60L);
                            this.addItemUse(list, "1", StyleType.TOOLTIP_DESC.toString() + "[" + timeString + "]");
                        }
                    } else {
                        this.addItemUse(list, "2", new Object[0]);
                    }
                    if (cap.canResetPerks((PlayerEntity)player)) {
                        this.addItemUse(list, "3", new Object[0]);
                    }
                });
            }
        } else {
            this.addInfoShowTooltip(list);
        }
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        return state.func_177230_c() instanceof BlockDecorativeGrave && (Boolean)state.func_177229_b((IProperty)BlockDecorativeGrave.HAS_SOUL) != false ? ActionResultType.PASS : ActionResultType.FAIL;
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (!EntityHelper.isValidPlayer(playerIn)) {
            return false;
        }
        if (!playerIn.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND && playerIn.func_184614_ca().func_77973_b() == this && !EntityHelper.hasCooldown(playerIn, this)) {
            ServerPlayerEntity player = (ServerPlayerEntity)playerIn;
            EntityHelper.setCooldown(playerIn, this, 10);
            if (target instanceof ZombieVillagerEntity) {
                return (Boolean)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> {
                    if (cap.canPray((PlayerEntity)player)) {
                        ZombieVillagerEntity villager = (ZombieVillagerEntity)target;
                        EntityHelper.addEffect((LivingEntity)villager, ModEffects.exorcism, 200, 1, new boolean[0]);
                        villager.field_191992_by = null;
                        villager.field_82234_d = 200;
                        villager.func_184212_Q().func_187227_b(ZombieVillagerEntity.field_184739_bx, (Object)Boolean.TRUE);
                        villager.func_195063_d(Effects.field_76437_t);
                        villager.field_70170_p.func_72960_a((Entity)villager, (byte)16);
                        cap.resetNextPray((PlayerEntity)player);
                        ServerPlayerEntity serverPlayer = player;
                        PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.NEXT_PRAY, cap.getNextPray()), serverPlayer);
                        EntityHelper.addKnowledge(serverPlayer, 3L);
                        Helper.damageItem(stack, 3, serverPlayer, Hand.MAIN_HAND);
                        player.func_145747_a(LangKey.MESSAGE_EXORCISM.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
                        ModTriggers.EXORCISM.trigger(player);
                        return true;
                    }
                    return false;
                }).orElse((Object)false);
            }
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (hand == Hand.MAIN_HAND && heldStack.func_77973_b() == this && !player.func_184811_cZ().func_185141_a((Item)this)) {
            return new ActionResult((ActionResultType)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> {
                if (cap.canPray(player)) {
                    ITextComponent failedMessage = null;
                    ItemStack offhand = player.func_184592_cb();
                    if (ModItems.familiar_receptacle.containSoul(offhand)) {
                        if (ModItems.familiar_receptacle.getDurabilityForDisplay(offhand) != 0.0) {
                            failedMessage = LangKey.MESSAGE_RECOVERING_RECEPTACLE.getTranslationWithStyle(StyleType.COLOR_OFF);
                        } else if (cap.getTotalPerkPoints() < 10) {
                            failedMessage = LangKey.MESSAGE_KNOWLEDGE_REQUIRED.getTranslationWithStyle(StyleType.COLOR_OFF, 10);
                        }
                        if (failedMessage != null) {
                            player.func_184811_cZ().func_185145_a((Item)this, 10);
                            if (!player.field_70170_p.field_72995_K) {
                                player.func_145747_a(failedMessage);
                            }
                            return ActionResultType.FAIL;
                        }
                    }
                    player.func_184598_c(hand);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.FAIL;
            }).orElse((Object)ActionResultType.FAIL), (Object)heldStack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)heldStack);
    }

    @Nullable
    private BlockPos findGraveAround(IWorld world, BlockPos startPos) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos currentPos = new BlockPos(startPos.func_177958_n() + x, startPos.func_177956_o() + y, startPos.func_177952_p() + z);
                    if (!(world.func_180495_p(currentPos).func_177230_c() instanceof BlockDecorativeGrave)) continue;
                    return currentPos;
                }
            }
        }
        return null;
    }

    public ItemStack func_77654_b(ItemStack stack, @Nullable World world, LivingEntity entity) {
        ServerPlayerEntity player;
        if (EntityHelper.isValidPlayerMP((Entity)entity) && !EntityHelper.hasCooldown((PlayerEntity)(player = (ServerPlayerEntity)entity), this)) {
            BlockPos gravePos = this.findGraveAround((IWorld)player.field_70170_p, player.func_180425_c());
            if (gravePos != null) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                    ItemStack offhandStack = player.func_184592_cb();
                    if (offhandStack.func_77973_b() == ModItems.familiar_receptacle) {
                        if (ModItems.familiar_receptacle.containSoul(offhandStack)) {
                            if (ModItems.familiar_receptacle.getDurabilityForDisplay(offhandStack) > 0.0) {
                                player.func_145747_a(LangKey.MESSAGE_RECOVERING_RECEPTACLE.getTranslationWithStyle(StyleType.COLOR_OFF));
                            } else if (ModItems.familiar_receptacle.revive((PlayerEntity)player, gravePos, offhandStack)) {
                                cap.resetNextPray((PlayerEntity)player);
                                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.NEXT_PRAY, cap.getNextPray()), player);
                                cap.addKnowledgeAndSync(player, 5L);
                                Helper.damageItem(stack, 1, player, Hand.MAIN_HAND);
                                ModTriggers.REVIVE_FAMILIAR.trigger(player);
                                player.func_145747_a(LangKey.MESSAGE_REVIVE_FAMILIAR.getTranslation(LangKey.MESSAGE_YOUR_FAMILIAR.getTranslation()));
                                offhandStack.func_190918_g(1);
                            } else {
                                CompoundNBT tag = offhandStack.func_77978_p();
                                if (tag != null) {
                                    tag.func_82580_o("dead_pet");
                                }
                                player.func_145747_a(LangKey.MESSAGE_CANT_REVIVE_FAMILIAR.getTranslationWithStyle(StyleType.COLOR_OFF, LangKey.MESSAGE_YOUR_FAMILIAR.getTranslation()));
                            }
                        } else {
                            player.func_145747_a(LangKey.MESSAGE_EMPTY_RECEPTACLE.getTranslationWithStyle(StyleType.COLOR_OFF));
                        }
                    } else {
                        cap.resetNextPray((PlayerEntity)player);
                        PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.NEXT_PRAY, cap.getNextPray()), player);
                        cap.addKnowledgeAndSync(player, 1L);
                        Helper.damageItem(stack, 1, player, Hand.MAIN_HAND);
                        ModTriggers.FIRST_PRAY.trigger(player);
                        if (EntityHelper.clearEffect((LivingEntity)player, Effects.field_220309_E)) {
                            player.func_145747_a(LangKey.MESSAGE_DISPEL_BAD_OMEN.getTranslationWithStyle(StyleType.MESSAGE_SPELL));
                        }
                        if (Helper.isDateAroundHalloween() || Helper.getRandom(1, 100) < (Integer)ConfigTombstone.decorative_grave.chancePrayReward.get() + cap.getTotalPerkPoints()) {
                            Helper.addRandomEffect((PlayerEntity)player, ConfigTombstone.decorative_grave.getCooldownToPray() * 5000, true);
                        }
                    }
                });
            } else {
                player.func_145747_a(LangKey.MESSAGE_CANT_PRAY.getTranslationWithStyle(StyleType.COLOR_OFF));
            }
            EntityHelper.setCooldown((PlayerEntity)player, this, 10);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        if (entity != null && entity.field_70170_p.field_72995_K && timeLeft == this.func_77626_a(stack)) {
            ModTombstone.PROXY.produceParticleCasting(entity, p -> !p.func_184587_cr());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || EntityHelper.hasCooldown((PlayerEntity)player, stack)) {
            return false;
        }
        return (Boolean)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> {
            if (!cap.canPray((PlayerEntity)player)) {
                EntityHelper.setCooldown((PlayerEntity)player, stack, (int)(cap.getNextPray() - TimeHelper.worldTicks(player.field_70170_p)));
                return false;
            }
            return true;
        }).orElse((Object)false);
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        if (!world.field_72995_K) {
            return (Boolean)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> cap.resetPerksAndSync((ServerPlayerEntity)player)).orElse((Object)false);
        }
        return false;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(PlayerEntity player) {
        return LangKey.MESSAGE_PERK_RESET_SUCCESS.getTranslation();
    }

    @Override
    public ITextComponent getEnchantFailedMessage(PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K) {
            return (ITextComponent)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> {
                long cd = cap.getCooldownToResetPerks(player);
                if (cd > 0L) {
                    int min = (int)(cd / 1200L);
                    if (min > 0) {
                        cd -= (long)(min * 1200);
                    }
                    return LangKey.MESSAGE_PERK_RESET_IN_COOLDOWN.getTranslation(min, cd / 20L);
                }
                return LangKey.MESSAGE_PERK_RESET_FAILED.getTranslation();
            }).orElse((Object)LangKey.MESSAGE_PERK_RESET_FAILED.getTranslation());
        }
        return LangKey.MESSAGE_PERK_RESET_FAILED.getTranslation();
    }

    @Override
    public int getKnowledge() {
        return 0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

