/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.GuiUtils;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.PerkRegistry;
import ovh.corail.tombstone.gui.GuiConfig;
import ovh.corail.tombstone.gui.GuiInfo;
import ovh.corail.tombstone.gui.TBGuiButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpgradePerkServerMessage;

@OnlyIn(value=Dist.CLIENT)
public class GuiKnowledge
extends TBScreen {
    static final ResourceLocation GUI_BACKGROUND = new ResourceLocation("tombstone", "textures/gui/knowledge.png");
    private static final ResourceLocation GUI_BAR = new ResourceLocation("minecraft", "textures/gui/bars.png");
    private static final ResourceLocation GUI_PERK = new ResourceLocation("tombstone", "textures/item/ankh.png");
    private final ITBCapability cap;
    private final int iconSize = 16;
    private final List<PerkIcon> icons = new ArrayList<PerkIcon>();
    private final int borderColor = -15524569;
    private final int textColor = -1980292;
    private PerkIcon hoveredIcon;
    private int leftPerkPoints;
    private int hoveredPerkLevel = 0;

    public GuiKnowledge(ITBCapability cap) {
        super(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getTranslation());
        this.cap = cap;
        for (Perk perk : PerkRegistry.perkRegistry.getValues()) {
            if (Helper.isDisabledPerk(perk)) continue;
            this.icons.add(new PerkIcon(perk));
        }
    }

    @Override
    public void init() {
        super.init();
        int x = this.guiLeft + 15;
        int y = this.guiTop + 58;
        int i = 0;
        int spaceForIcon = this.icons.size() > 10 ? 20 : 30;
        int maxIconByLine = this.icons.size() > 10 ? 7 : 5;
        for (PerkIcon icon : this.icons) {
            int caseX = i % maxIconByLine;
            icon.setPosition(x + caseX * spaceForIcon, y);
            if (caseX == maxIconByLine - 1) {
                y += 30;
            }
            ++i;
        }
        this.addButton((Widget)new TBGuiButton((this.width - 150) / 2, this.guiTop + 146, 70, 15, I18n.func_135052_a((String)"tombstone.compendium.main.title", (Object[])new Object[0]), pressable -> this.getMinecraft().func_147108_a((Screen)new GuiInfo(null))));
        this.addButton((Widget)new TBGuiButton((this.width + 10) / 2, this.guiTop + 146, 70, 15, LangKey.BUTTON_CONFIG.getClientTranslation(new Object[0]), pressable -> this.getMinecraft().func_147108_a((Screen)new GuiConfig())));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.hoveredIcon != null) {
            if (mouseButton == 0) {
                int perkLevel = this.cap.getPerkLevel((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk);
                if (perkLevel < this.hoveredIcon.perk.getLevelMax() && this.leftPerkPoints >= this.hoveredIcon.perk.getCost(perkLevel + 1)) {
                    PacketHandler.sendToServer(new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.UPGRADE_PERK, this.hoveredIcon.perk));
                    return true;
                }
            } else if (mouseButton == 1 && this.getMinecraft().field_71439_g.func_184812_l_() && this.cap.getPerkLevel((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk) > 0) {
                PacketHandler.sendToServer(new UpgradePerkServerMessage(UpgradePerkServerMessage.SyncType.DOWNGRADE_PERK, this.hoveredIcon.perk));
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        this.renderBackground();
        this.hoveredIcon = this.icons.stream().filter(p -> p.contains(mouseX, mouseY)).findFirst().orElse(null);
        int totalPerkPoints = this.cap.getTotalPerkPoints();
        int usedPerkPoints = this.cap.getUsedPerkPoints((PlayerEntity)this.getMinecraft().field_71439_g);
        this.leftPerkPoints = totalPerkPoints - usedPerkPoints;
        GlStateManager.pushMatrix();
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
        GlStateManager.disableLighting();
        GlStateManager.disableDepthTest();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.hLine(this.guiLeft + 5, this.guiLeft + this.xSize - 5, this.guiTop + 4, this.textColor);
        this.hLine(this.guiLeft + 5, this.guiLeft + this.xSize - 5, this.guiTop + 6, this.textColor);
        String titleName = LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getClientTranslation(new Object[0]);
        this.font.func_211126_b(titleName, (float)(this.width / 2 - this.font.func_78256_a(titleName) / 2), (float)(this.guiTop + 9), this.textColor);
        this.hLine(this.guiLeft + 5, this.guiLeft + this.xSize - 5, this.guiTop + 18, this.textColor);
        this.hLine(this.guiLeft + 5, this.guiLeft + this.xSize - 5, this.guiTop + 20, this.textColor);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().field_71446_o.func_110577_a(GUI_BAR);
        GuiKnowledge.blit((int)(this.guiLeft + 20), (int)(this.guiTop + 30), (float)0.0f, (float)40.0f, (int)182, (int)5, (int)182, (int)256);
        GuiKnowledge.blit((int)(this.guiLeft + 20), (int)(this.guiTop + 30), (float)0.0f, (float)45.0f, (int)((int)(129.22 * (double)(this.cap.getKnowledge() - this.cap.getKnowledgeForLevel(totalPerkPoints)) / (double)this.cap.getKnowledgeToReachNextLevel(totalPerkPoints + 1))), (int)5, (int)182, (int)256);
        GuiKnowledge.blit((int)(this.guiLeft + 20), (int)(this.guiTop + 31), (float)0.0f, (float)101.0f, (int)182, (int)3, (int)182, (int)256);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().field_71446_o.func_110577_a(GUI_PERK);
        GuiKnowledge.blit((int)(this.guiLeft + 35), (int)(this.guiTop + 42), (int)0, (int)0, (float)64.0f, (float)64.0f, (int)8, (int)8, (int)64, (int)64);
        this.font.func_211126_b(this.leftPerkPoints + " / " + totalPerkPoints, (float)(this.guiLeft + 50), (float)(this.guiTop + 43), -7769547);
        for (PerkIcon icon : this.icons) {
            this.drawPerk(icon);
        }
        int currentY = this.guiTop + 110;
        if (Helper.isContributor((PlayerEntity)this.getMinecraft().field_71439_g)) {
            this.font.func_211126_b("- Contributor", (float)(this.guiLeft + 20), (float)(currentY += 10), 8858573);
        }
        if (Helper.isDateAroundHalloween()) {
            this.font.func_211126_b("- Halloween", (float)(this.guiLeft + 20), (float)(currentY += 10), 8858573);
        }
        super.render(mouseX, mouseY, partialTick);
        this.drawPerkTooltip();
        GlStateManager.enableLighting();
        GlStateManager.enableDepthTest();
        RenderHelper.func_74519_b();
        GlStateManager.enableRescaleNormal();
        GlStateManager.popMatrix();
    }

    private void drawPerk(PerkIcon icon) {
        int levelWithBonus = this.cap.getPerkLevelWithBonus((PlayerEntity)this.getMinecraft().field_71439_g, icon.perk);
        GlStateManager.pushMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiKnowledge.fill((int)(icon.getMinX() - 1), (int)(icon.getMinY() - 1), (int)(icon.getMaxX() + 1), (int)(icon.getMaxY() + 1 + 10), (int)this.borderColor);
        if (levelWithBonus == 0 && (this.hoveredIcon == null || icon != this.hoveredIcon)) {
            this.fillGradient(icon.getMinX(), icon.getMinY(), icon.getMaxX(), icon.getMaxY(), -13421773, -13421773);
            GlStateManager.color4f((float)0.13f, (float)0.13f, (float)0.13f, (float)0.5f);
        } else {
            this.fillGradient(icon.getMinX(), icon.getMinY(), icon.getMaxX(), icon.getMaxY(), -16703669, -7096363);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (icon.perk != ModPerks.alchemist) {
            ResourceLocation texture = icon.perk.getIcon();
            if (texture != null) {
                this.getMinecraft().func_110434_K().func_110577_a(texture);
                GuiKnowledge.blit((int)icon.getMinX(), (int)icon.getMinY(), (float)0.0f, (float)0.0f, (int)this.iconSize, (int)this.iconSize, (int)this.iconSize, (int)this.iconSize);
            }
        } else {
            this.itemRenderer.func_180450_b(new ItemStack((IItemProvider)Items.field_185157_bK), icon.getMinX(), icon.getMinY());
        }
        boolean hasBonus = icon.perk.getLevelBonus((PlayerEntity)this.getMinecraft().field_71439_g) != 0;
        this.font.func_211126_b("" + levelWithBonus, (float)icon.getMinX() + (levelWithBonus > 9 ? 2.5f : 5.5f), (float)(icon.getMinY() + 18), hasBonus ? 8858573 : this.textColor);
        GlStateManager.popMatrix();
    }

    private void drawPerkTooltip() {
        if (this.hoveredIcon != null) {
            this.hoveredPerkLevel = this.cap.getPerkLevel((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk);
            int levelWithBonus = this.cap.getPerkLevelWithBonus((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk);
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.hoveredIcon.perk.getClientTranslation());
            String specialInfo = this.hoveredIcon.perk.getSpecialInfo(levelWithBonus);
            if (!specialInfo.isEmpty()) {
                list.add(specialInfo);
            }
            IntStream.rangeClosed(1, this.hoveredIcon.perk.getLevelMax()).forEach(i -> {
                String info = this.hoveredIcon.perk.getTooltip(i, this.hoveredPerkLevel, levelWithBonus);
                if (!info.isEmpty()) {
                    list.add((this.hoveredPerkLevel >= i ? TextFormatting.WHITE : ((this.hoveredIcon.perk.isEncrypted() ? levelWithBonus >= i : levelWithBonus == i) ? TextFormatting.DARK_PURPLE : TextFormatting.DARK_GRAY)).toString() + i + " -> " + LangKey.getClientTranslation(info, new Object[0]));
                }
            });
            if (this.hoveredPerkLevel < this.hoveredIcon.perk.getLevelMax()) {
                int cost = this.hoveredIcon.perk.getCost(this.hoveredPerkLevel + 1);
                boolean canUpgrade = this.leftPerkPoints >= cost;
                list.add((canUpgrade ? TextFormatting.AQUA : TextFormatting.RED) + LangKey.MESSAGE_COST.getClientTranslation(cost));
                list.add(canUpgrade ? TextFormatting.BLUE + LangKey.MESSAGE_CLICK_TO_UPGRADE.getClientTranslation(new Object[0]) : TextFormatting.RED + LangKey.MESSAGE_CANT_UPGRADE.getClientTranslation(new Object[0]));
            } else {
                list.add(TextFormatting.GOLD + LangKey.MESSAGE_MAX.getClientTranslation(new Object[0]));
            }
            this.drawHoveringText(list, this.hoveredIcon.minX + 10, this.hoveredIcon.minY + 10, this.font);
        }
    }

    private void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
        int maxTextWidth = 200;
        if (!textLines.isEmpty()) {
            GlStateManager.disableRescaleNormal();
            RenderHelper.func_74518_a();
            GlStateManager.disableLighting();
            GlStateManager.disableDepthTest();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = x + 12;
            if (tooltipX + tooltipTextWidth + 4 > this.width && (tooltipX = x - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = x > this.width / 2 ? x - 12 - 8 : this.width - 16 - x;
                needsWrap = true;
            }
            if (tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = x > this.width / 2 ? x - 16 - tooltipTextWidth : x + 12;
            }
            int tooltipY = y - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > this.height) {
                tooltipY = this.height - tooltipHeight - 4;
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            int borderColorStart = 0x505000FF;
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
            int perkLine = 0;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                boolean isPerkLine;
                String line = textLines.get(lineNumber);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                String[] splits = line.split(" -> ");
                boolean bl = isPerkLine = splits.length > 1;
                if (isPerkLine && this.hoveredIcon.perk.isEncrypted() && perkLine > this.cap.getPerkLevelWithBonus((PlayerEntity)this.getMinecraft().field_71439_g, this.hoveredIcon.perk)) {
                    String subString = splits[0] + " -> ";
                    font.func_211126_b(subString, (float)tooltipX, (float)tooltipY, -1980292);
                    FontRenderer standardGalacticFontRenderer = this.getMinecraft().func_211500_ak().func_211504_a(Minecraft.field_71464_q);
                    if (standardGalacticFontRenderer != null) {
                        standardGalacticFontRenderer.func_211126_b(TextFormatting.DARK_GRAY + splits[1], (float)(tooltipX + font.func_78256_a(subString)), (float)tooltipY, -1980292);
                    }
                } else {
                    font.func_211126_b(line, (float)tooltipX, (float)tooltipY, -1980292);
                }
                if (isPerkLine) {
                    ++perkLine;
                }
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            GlStateManager.enableLighting();
            GlStateManager.enableDepthTest();
            RenderHelper.func_74519_b();
            GlStateManager.enableRescaleNormal();
        }
    }

    public class PerkIcon {
        public final Perk perk;
        int minX;
        int minY;
        int maxX;
        int maxY;

        PerkIcon(Perk perk) {
            this.perk = perk;
        }

        void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 16;
            this.maxY = y + 16;
        }

        boolean contains(double x, double y) {
            return x >= (double)this.minX && y >= (double)this.minY && x <= (double)this.maxX && y <= (double)this.maxY;
        }

        int getMinX() {
            return this.minX;
        }

        int getMinY() {
            return this.minY;
        }

        int getMaxX() {
            return this.maxX;
        }

        int getMaxY() {
            return this.maxY;
        }
    }
}

