/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.api.magic.ModDamages;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBRequestTeleport;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.DummyTargetEntity;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.PhantomSpawnerHandler;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.VillageSiegeHandler;
import ovh.corail.tombstone.item.ItemVoodooPoppet;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.TombstoneActivatedMessage;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityGrave;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    private static ResourceLocation LOOTTABLE_SPECIAL = new ResourceLocation("tombstone", "special");
    private static final Field fieldIsFrozen = ObfuscationReflectionHelper.findField(LootTable.class, (String)"isFrozen");
    private static final Field fieldLootEntries = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");
    private static final Field fieldWeight = ObfuscationReflectionHelper.findField(StandaloneLootEntry.class, (String)"field_216158_e");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LootTables.field_186388_am)) {
            ConfigTombstone.updateServerDatas();
            ((ThreadTaskExecutor)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER)).func_213165_a(() -> {
                LootTable specialTable = event.getLootTableManager().func_186521_a(LOOTTABLE_SPECIAL);
                if (specialTable == LootTable.field_186464_a) {
                    ModTombstone.LOGGER.warn("The special loottable for Tombstone is absent");
                } else {
                    LootPool fishTreasure = specialTable.getPool("tombstone:lost_tablet");
                    try {
                        fieldIsFrozen.set(specialTable, false);
                        List entries = (List)fieldLootEntries.get(fishTreasure);
                        fieldWeight.set(entries.get(0), ConfigTombstone.loot.getChanceLootLostTablet());
                        fieldWeight.set(entries.get(1), 100 - ConfigTombstone.loot.getChanceLootLostTablet());
                        fieldIsFrozen.set(specialTable, true);
                        fieldIsFrozen.set(event.getTable(), false);
                        event.getTable().addPool(fishTreasure);
                        fieldIsFrozen.set(event.getTable(), true);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    LootPool chestTreasure = specialTable.getPool("tombstone:chest_treasure");
                    for (String targetTableString : (List)ConfigTombstone.loot.treasureLootTable.get()) {
                        LootTable currentTable = event.getLootTableManager().func_186521_a(new ResourceLocation(targetTableString));
                        if (currentTable == LootTable.field_186464_a) continue;
                        try {
                            fieldIsFrozen.set(currentTable, false);
                            currentTable.addPool(chestTreasure);
                            fieldIsFrozen.set(currentTable, true);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        long systemTicks;
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER && TimeHelper.atInterval(systemTicks = TimeHelper.systemTicks(), TimeHelper.tickFromMinute(1))) {
            if (((Boolean)ConfigTombstone.recovery.recoveryPlayerEnable.get()).booleanValue() && TimeHelper.atInterval(systemTicks, TimeHelper.tickFromMinute((Integer)ConfigTombstone.recovery.recoveryPlayerTimer.get()))) {
                CommandTBRecovery.saveAllPlayers((MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER), success -> ModTombstone.LOGGER.info(success != false ? "All players have been successfully backed up" : "Some players could not be backed up"));
            }
            CommandTBRequestTeleport.cleanTickets(systemTicks);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> {
            Block block = event.getWorld().func_180495_p(blockPos).func_177230_c();
            return block.func_203417_a(ModTags.Blocks.graves) || block.func_203417_a(ModTags.Blocks.grave_marbles);
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBreak(BlockEvent.BreakEvent event) {
        if (((Boolean)ConfigTombstone.general.nerfGhostlyShape.get()).booleanValue() && EntityHelper.isPotionActive((LivingEntity)event.getPlayer(), ModEffects.ghostly_shape)) {
            event.getPlayer().func_195063_d(ModEffects.ghostly_shape);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRightClickChest(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getHand() == Hand.MAIN_HAND && ((Boolean)ConfigTombstone.general.nerfGhostlyShape.get()).booleanValue() && EntityHelper.isPotionActive((LivingEntity)event.getEntityPlayer(), ModEffects.ghostly_shape) && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof ChestBlock) {
            event.getEntityPlayer().func_195063_d(ModEffects.ghostly_shape);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            VillageSiegeHandler.instance.checkWorld((ServerWorld)event.getWorld());
            PhantomSpawnerHandler.instance.checkWorld((ServerWorld)event.getWorld());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        if (EntityHelper.isPotionActive(event.getEntityLiving(), ModEffects.unstable_intangibleness) && EntityHelper.getPotionDuration(event.getEntityLiving(), ModEffects.unstable_intangibleness) % 100 > 79) {
            event.setCanceled(true);
            return;
        }
        if (EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && EntityHelper.isPotionActive(event.getEntityLiving(), ModEffects.ghostly_shape, 5) && Helper.isValidPos(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_180425_c())) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource() != null && EntityHelper.isValidPlayer(event.getSource().func_76346_g())) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            if (event.getEntityLiving() != player) {
                if (EntityHelper.isPotionActive((LivingEntity)player, ModEffects.ghostly_shape)) {
                    player.func_195063_d(ModEffects.ghostly_shape);
                    if (EntityHelper.isValidPlayerMP((Entity)player)) {
                        ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((ServerPlayerEntity)player);
                    }
                }
                if (EntityHelper.isPotionActive((LivingEntity)player, ModEffects.diversion)) {
                    player.func_195063_d(ModEffects.diversion);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPreventDeath(LivingDamageEvent event) {
        if (EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving()) && event.getEntityLiving().func_110143_aJ() <= event.getAmount()) {
            Location spawnPos;
            ItemStack soul;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            ItemVoodooPoppet.PoppetProtections prot = ModItems.voodoo_poppet.getPoppetProtections(event.getSource());
            if (prot != null && ModItems.voodoo_poppet.preventDeath((PlayerEntity)player, InventoryHelper.findItemInMainInventory((PlayerEntity)player, p -> ModItems.voodoo_poppet.canPreventDeath((ItemStack)p, prot)), prot)) {
                event.setCanceled(true);
                player.func_145747_a(prot.getLangKey().getTranslation().func_150255_a(StyleType.MESSAGE_SPECIAL.getStyle()));
                ModTriggers.PREVENT_DEATH.get((Object)prot).trigger(player);
                return;
            }
            boolean preventDeathOutsideWorld = (Boolean)ConfigTombstone.general.preventDeathOutsideWorld.get() != false && !Helper.isValidPos(player.field_70170_p, player.func_180425_c());
            ItemStack itemStack = soul = !preventDeathOutsideWorld ? InventoryHelper.findItemInMainInventory((PlayerEntity)player, p -> p.func_77973_b() == ModItems.soul_receptacle) : ItemStack.field_190927_a;
            if (!(!preventDeathOutsideWorld && soul.func_190926_b() || (spawnPos = new SpawnHelper((ServerWorld)player.field_70170_p, Helper.getCloserValidPos(player.field_70170_p, new BlockPos((Entity)player))).findSpawnPlace(false)).isOrigin())) {
                event.setCanceled(true);
                if (!preventDeathOutsideWorld) {
                    soul.func_190918_g(1);
                }
                player.func_70606_j(player.func_110138_aP());
                EntityHelper.clearBadEffects((LivingEntity)player);
                EntityHelper.addEffect((LivingEntity)player, Effects.field_76443_y, 1200, 10, new boolean[0]);
                EntityHelper.addEffect((LivingEntity)player, Effects.field_76428_l, 1200, 10, new boolean[0]);
                EntityHelper.addEffect((LivingEntity)player, ModEffects.diversion, 1200);
                player.func_145747_a((preventDeathOutsideWorld ? LangKey.MESSAGE_CONFIG_PREVENT_DEATH : LangKey.MESSAGE_SOUL_PREVENT_DEATH).getTranslation());
                Helper.teleportEntity(player, spawnPos);
                player.field_70143_R = 0.0f;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckAttack(LivingSetAttackTargetEvent event) {
        int lvl;
        if (EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) || event.getTarget() == null) {
            return;
        }
        LivingEntity attacker = event.getEntityLiving();
        if (EntityHelper.isPotionActive(event.getTarget(), ModEffects.ghostly_shape) || EntityHelper.isPotionActive(event.getTarget(), ModEffects.diversion)) {
            ((MobEntity)attacker).field_70696_bz = null;
            if (attacker.field_70755_b == event.getTarget()) {
                attacker.field_70755_b = new DummyTargetEntity(attacker.field_70170_p);
            }
            return;
        }
        if (!ConfigTombstone.enchantments.isEnableEnchantmentShadowStep() || ((Boolean)ConfigTombstone.enchantments.restrictShadowStepToPlayer.get()).booleanValue() && !EntityHelper.isValidPlayer((Entity)event.getTarget())) {
            return;
        }
        if (ConfigTombstone.enchantments.isNerfShadowStep() && !event.getTarget().func_70093_af()) {
            return;
        }
        if (attacker.field_70755_b != event.getTarget() && !event.getTarget().func_184218_aH() && (lvl = Math.min(EntityHelper.getEnchantmentLevel(event.getTarget(), ModEnchantments.shadow_step), 5)) > 0) {
            IAttributeInstance attribute = attacker.func_110148_a(SharedMonsterAttributes.field_111265_b);
            double range = attribute == null ? 16.0 : attribute.func_111126_e();
            double mult = MathHelper.func_151237_a((double)((event.getTarget().func_70093_af() ? 0.6 : 1.0) - (double)lvl * 0.2 + (attacker.field_70170_p.func_72935_r() ? 0.5 : 0.0)), (double)0.05, (double)1.0);
            if ((double)attacker.func_70032_d((Entity)event.getTarget()) < range * mult) {
                attacker.field_70755_b = event.getTarget();
                attacker.field_70756_c = attacker.field_70173_aa;
            } else {
                ((MobEntity)attacker).field_70696_bz = null;
                if (attacker.field_70755_b == event.getTarget()) {
                    attacker.field_70755_b = new DummyTargetEntity(attacker.field_70170_p);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!EntityHelper.isValidPlayer(event.getPlayer()) || event.getPlayer().func_175149_v()) {
            return;
        }
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        if (deathHandler.isPlayerDead(event.getPlayer())) {
            ListIterator it = event.getPlayer().field_71071_by.field_70462_a.listIterator();
            while (it.hasNext()) {
                if (!InventoryHelper.autoequip((ItemStack)it.next(), event.getPlayer())) continue;
                it.set(ItemStack.field_190927_a);
            }
            deathHandler.restorePlayerDead(event.getPlayer());
            event.getPlayer().field_71069_bz.func_75142_b();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onUndeadDrops(LivingDropsEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            DeathHandler.INSTANCE.handleMobDrops(event.getEntityLiving(), event.getSource(), event.getDrops());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void give(PlayerEvent.Clone event) {
        PlayerEntity player = event.getEntityPlayer();
        PlayerEntity original = event.getOriginal();
        if (!event.isWasDeath() || original == null || !EntityHelper.isValidPlayer(player)) {
            return;
        }
        if (!((Boolean)ConfigTombstone.general.handlePlayerDeath.get()).booleanValue() || Helper.isRuleKeepInventory(player)) {
            return;
        }
        ArrayList misplaced_stacks = new ArrayList();
        for (int i = 0; i < event.getOriginal().field_71071_by.field_70462_a.size(); ++i) {
            ItemStack originalStack = (ItemStack)event.getOriginal().field_71071_by.field_70462_a.get(i);
            if (originalStack.func_190926_b()) continue;
            int currentSlot = i;
            player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(inventPlayer -> {
                ItemStack playerStack = inventPlayer.getStackInSlot(currentSlot);
                if (!playerStack.func_190926_b()) {
                    if (!ItemStack.func_77989_b((ItemStack)originalStack, (ItemStack)playerStack)) {
                        ModTombstone.LOGGER.warn("An item was different from the original");
                        misplaced_stacks.add(inventPlayer.extractItem(currentSlot, playerStack.func_190916_E(), false));
                        inventPlayer.insertItem(currentSlot, originalStack.func_77946_l(), false);
                    }
                } else {
                    inventPlayer.insertItem(currentSlot, originalStack.func_77946_l(), false);
                }
            });
        }
        for (ItemStack stack : misplaced_stacks) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
        }
        DeathHandler.INSTANCE.addPlayerDead(original);
        if (!EntityHelper.isSurvivalPlayer(player)) {
            return;
        }
        boolean hasPreservation = EntityHelper.isPotionActive((LivingEntity)player, ModEffects.preservation);
        if (hasPreservation || ConfigTombstone.general.isHandlingPlayerXp()) {
            original.field_71067_cb = EntityHelper.getPlayerTotalXp(original);
            if (hasPreservation || ConfigTombstone.general.getXpLoss() == 0 || player.func_184812_l_()) {
                player.field_71067_cb = original.field_71067_cb;
                player.field_71106_cc = original.field_71106_cc;
                player.field_71068_ca = original.field_71068_ca;
            } else {
                int bonus = EntityHelper.getPerkLevelWithBonus(player, ModPerks.memento_mori) * 20;
                EntityHelper.setPlayerXp(player, original.field_71067_cb * MathHelper.func_76125_a((int)(100 + bonus - ConfigTombstone.general.getXpLoss()), (int)0, (int)100) / 100);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving())) {
            return;
        }
        if (event.isCanceled()) {
            if (((Boolean)ConfigTombstone.general.handlePlayerDeath.get()).booleanValue()) {
                ModTombstone.LOGGER.warn("The death event of the player " + event.getEntityLiving().func_200200_C_() + " was cancelled by another mod");
            }
        } else {
            event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                INBT tbCapTag;
                int knowledgeLoss;
                int n = knowledgeLoss = (Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get() != false && event.getSource() == ModDamages.BEYOND_THE_GRAVE ? 10 : 0;
                if ((Integer)ConfigTombstone.general.knowledgeLoss.get() > 0) {
                    knowledgeLoss += ((Integer)ConfigTombstone.general.knowledgeLoss.get()).intValue();
                }
                if (knowledgeLoss > 0) {
                    cap.removeKnowledgeAndSync((ServerPlayerEntity)event.getEntityLiving(), knowledgeLoss);
                }
                if ((tbCapTag = TBCapabilityProvider.TB_CAPABILITY.writeNBT(cap, null)) != null) {
                    CompoundNBT entityData = event.getEntityLiving().getPersistentData();
                    CompoundNBT persistantTag = entityData.func_74764_b("PlayerPersisted") ? (CompoundNBT)entityData.func_74781_a("PlayerPersisted") : new CompoundNBT();
                    persistantTag.func_218657_a("tombstone_cap", tbCapTag);
                    entityData.func_218657_a("PlayerPersisted", (INBT)persistantTag);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (ConfigTombstone.general.isHandlingPlayerXp() && EntityHelper.isValidPlayer((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    private static void storeSoulboundsOnBody(PlayerEntity player, List<ItemStack> keys, List<ItemStack> soulbounds) {
        for (ItemStack key : keys) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)key);
        }
        keys.clear();
        for (ItemStack soulbound : soulbounds) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)soulbound);
        }
        soulbounds.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDrops(LivingDropsEvent event) {
        boolean needAccess;
        BlockState state;
        boolean hasGrave;
        TileEntity tile;
        Location lastGrave;
        boolean hasDrop;
        if (!EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving())) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
        if (Helper.isRuleKeepInventory((PlayerEntity)player)) {
            return;
        }
        ServerWorld world = player.func_71121_q();
        if (event.isCanceled()) {
            ModTombstone.LOGGER.warn("The drop event of the player " + player.func_146103_bH().getName() + " was cancelled by another mod");
            return;
        }
        Iterator it = event.getDrops().iterator();
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        ArrayList<ItemStack> soulbounds = new ArrayList<ItemStack>();
        while (it.hasNext()) {
            ItemEntity entityItem = (ItemEntity)it.next();
            if (entityItem == null || entityItem.func_92059_d().func_190926_b()) continue;
            ItemStack stack = entityItem.func_92059_d();
            if (stack.func_77973_b() == ModItems.grave_key) {
                keys.add(stack.func_77946_l());
                it.remove();
                continue;
            }
            if (!ConfigTombstone.enchantments.isEnableEnchantmentSoulbound() || EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.soulbound, (ItemStack)stack) <= 0) continue;
            soulbounds.add(stack.func_77946_l());
            it.remove();
        }
        double range = ((Integer)ConfigTombstone.general.snifferRange.get()).intValue();
        List itemList = player.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(player.field_70165_t - range, player.field_70163_u - range, player.field_70161_v - range, player.field_70165_t + range, player.field_70163_u + range, player.field_70161_v + range));
        it = itemList.listIterator();
        while (it.hasNext()) {
            ItemEntity entityItem = (ItemEntity)it.next();
            if (entityItem == null || entityItem.func_92059_d().func_190926_b()) continue;
            ItemStack stack = entityItem.func_92059_d();
            if (stack.func_77973_b() == ModItems.grave_key) {
                keys.add(stack.func_77946_l());
                it.remove();
                continue;
            }
            if (!ConfigTombstone.enchantments.isEnableEnchantmentSoulbound() || EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.soulbound, (ItemStack)stack) <= 0) continue;
            soulbounds.add(stack.func_77946_l());
            it.remove();
        }
        boolean bl = hasDrop = itemList.size() > 0 || event.getDrops().size() > 0;
        if (!((Boolean)ConfigTombstone.general.handlePlayerDeath.get()).booleanValue() || !hasDrop) {
            ModItems.grave_key.reenchantOnDeath((PlayerEntity)player, keys.stream().filter(p -> !ModItems.grave_key.isEnchanted((ItemStack)p)).findFirst().orElse(ItemStack.field_190927_a));
            EventHandler.storeSoulboundsOnBody((PlayerEntity)player, keys, soulbounds);
            if (!hasDrop) {
                player.func_145747_a(LangKey.MESSAGE_NO_LOOT_FOR_GRAVE.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
            }
            return;
        }
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        if (deathHandler.isNoGraveLocation(new Location((Entity)player))) {
            player.func_145747_a(LangKey.MESSAGE_NO_GRAVE_LOCATION.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
            EventHandler.storeSoulboundsOnBody((PlayerEntity)player, keys, soulbounds);
            return;
        }
        BlockPos initPos = Helper.getCloserValidPos((World)world, new BlockPos((Entity)player));
        Location spawnPos = ((Chunk)world.func_217349_x(initPos)).func_177434_r().entrySet().stream().filter(grave -> {
            TileEntityGrave tileGrave;
            if (grave.getValue() instanceof TileEntityGrave && (tileGrave = (TileEntityGrave)((Object)((Object)grave.getValue()))).getOwnerName().equals(player.func_146103_bH().getName())) {
                return (Boolean)tileGrave.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(graveInvent -> (long)event.getDrops().size() <= IntStream.range(0, graveInvent.getSlots()).filter(slot -> graveInvent.getStackInSlot(slot).func_190926_b()).count()).orElse((Object)false);
            }
            return false;
        }).map(p -> new Location((BlockPos)p.getKey(), (IWorld)world)).findFirst().orElse(Location.ORIGIN);
        if (spawnPos.isOrigin() && !(lastGrave = deathHandler.getLastGrave(player.func_146103_bH().getName())).isOrigin() && lastGrave.dim == Helper.getDimensionId((IWorld)world) && lastGrave.getPos().func_177951_i((Vec3i)initPos) <= 400.0 && (tile = world.func_175625_s(lastGrave.getPos())) instanceof TileEntityGrave) {
            TileEntityGrave grave2 = (TileEntityGrave)tile;
            if (event.getDrops().size() <= (Integer)grave2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(graveInvent -> (int)IntStream.range(0, graveInvent.getSlots()).filter(slot -> graveInvent.getStackInSlot(slot).func_190926_b()).count()).orElse((Object)0)) {
                spawnPos = lastGrave;
            }
        }
        boolean bl2 = hasGrave = !spawnPos.isOrigin();
        if (!hasGrave && (spawnPos = new SpawnHelper(world, initPos).findSpawnPlace(true)).isOrigin()) {
            EventHandler.storeSoulboundsOnBody((PlayerEntity)player, keys, soulbounds);
            player.func_145747_a(LangKey.MESSAGE_NO_PLACE_FOR_GRAVE.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
            ModTombstone.LOGGER.info("There was nowhere to place the grave!");
            return;
        }
        if (!hasGrave) {
            deathHandler.logLastGrave((PlayerEntity)player, spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim);
            Direction facing = player.func_174811_aO().func_176734_d();
            Pair<GraveModel, BlockGraveMarble.MarbleType> favoriteGrave = deathHandler.getFavoriteGrave(player);
            Block graveBlock = ModBlocks.graves.get(favoriteGrave.getLeft());
            state = (BlockState)((BlockState)((BlockState)graveBlock.func_176223_P().func_206870_a((IProperty)BlockGraveBase.FACING, (Comparable)facing)).func_206870_a((IProperty)BlockGraveBase.IS_ENGRAVED, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)BlockGraveBase.MODEL_TEXTURE, (Comparable)Integer.valueOf(((BlockGraveMarble.MarbleType)((Object)favoriteGrave.getRight())).ordinal()));
            Helper.placeNoEvent((World)world, spawnPos.getPos(), state);
        } else {
            state = world.func_180495_p(spawnPos.getPos());
        }
        TileEntity tile2 = world.func_175625_s(spawnPos.getPos());
        if (!(tile2 instanceof TileEntityGrave)) {
            EventHandler.storeSoulboundsOnBody((PlayerEntity)player, keys, soulbounds);
            player.func_145747_a(LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
            ModTombstone.LOGGER.info((Object)LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.getTranslation());
            return;
        }
        TileEntityGrave grave3 = (TileEntityGrave)tile2;
        if (hasGrave) {
            grave3.resetDeathTime();
            grave3.countTicks = 0;
        }
        boolean bl3 = needAccess = (Boolean)ConfigTombstone.general.playerGraveAccess.get() != false && (Integer)ConfigTombstone.general.decayTime.get() != 0;
        if (needAccess && ((Boolean)ConfigTombstone.general.pvpMode.get()).booleanValue() && event.getSource() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            needAccess = false;
        }
        player.func_145747_a((hasGrave ? LangKey.MESSAGE_EXISTING_GRAVE : LangKey.MESSAGE_NEW_GRAVE).getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, LangKey.MESSAGE_JOURNEYMAP.getTranslationWithStyle(StyleType.TOOLTIP_DESC, LangKey.MESSAGE_LAST_GRAVE.getTranslation(), spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim), LangKey.createComponentTranslationWithStyle((PlayerEntity)player, needAccess ? StyleType.COLOR_OFF : StyleType.COLOR_ON, needAccess ? LangKey.MESSAGE_LOCKED : LangKey.MESSAGE_UNLOCKED, needAccess && (Integer)ConfigTombstone.general.decayTime.get() > 0 ? ConfigTombstone.general.decayTime.get() + " min" : "")));
        if (((Boolean)ConfigTombstone.general.playerGraveAccess.get()).booleanValue() || ((Boolean)ConfigTombstone.general.graveKeyOnDeath.get()).booleanValue()) {
            ItemStack key;
            if (hasGrave) {
                key = ItemStack.field_190927_a;
                for (ItemStack aKey : keys) {
                    if (!ModItems.grave_key.getTombPos(aKey).equals(spawnPos)) continue;
                    ModItems.grave_key.reenchantOnDeath((PlayerEntity)player, aKey);
                    key = aKey;
                    break;
                }
                if (key.func_190926_b()) {
                    key = new ItemStack((IItemProvider)ModItems.grave_key);
                    ModItems.grave_key.setTombPos(key, spawnPos);
                    ModItems.grave_key.reenchantOnDeath((PlayerEntity)player, key);
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)key);
                }
            } else {
                key = new ItemStack((IItemProvider)ModItems.grave_key);
                ModItems.grave_key.setTombPos(key, spawnPos);
                ModItems.grave_key.reenchantOnDeath((PlayerEntity)player, key);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)key);
            }
        }
        EventHandler.storeSoulboundsOnBody((PlayerEntity)player, keys, soulbounds);
        grave3.setOwner((Entity)player, TimeHelper.systemTime(), needAccess);
        boolean hasLosses = Helper.getRandom(1, 100) <= (Integer)ConfigTombstone.general.chanceLossOnDeath.get();
        int countLoss = 0;
        it = event.getDrops().iterator();
        while (it.hasNext()) {
            ItemEntity entityItem = (ItemEntity)it.next();
            if (entityItem == null || entityItem.func_92059_d().func_190926_b()) continue;
            ItemStack stack = entityItem.func_92059_d();
            if (hasLosses && stack.func_77985_e() && !stack.func_77942_o() && Helper.getRandom(1, 100) <= (Integer)ConfigTombstone.general.percentLossOnDeath.get()) {
                it.remove();
                ++countLoss;
                continue;
            }
            grave3.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(itemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack.func_77946_l(), (boolean)false));
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        if (countLoss > 0) {
            ItemStack junkStack = Helper.isDateAroundHalloween() ? new ItemStack((IItemProvider)ModItems.lollipop[world.field_73012_v.nextInt(ModItems.lollipop.length)], Helper.getRandom(1, 3)) : (countLoss > 5 ? new ItemStack((IItemProvider)ModItems.grave_dust) : (countLoss > 2 ? new ItemStack((IItemProvider)Items.field_151055_y) : new ItemStack((IItemProvider)Blocks.field_196555_aI)));
            grave3.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(itemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)junkStack, (boolean)false));
            player.func_145747_a(LangKey.MESSAGE_LOSSES_ON_DEATH.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
        }
        for (ItemEntity entityItem : itemList) {
            grave3.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(itemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d(), (boolean)false));
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        world.func_184138_a(spawnPos.getPos(), Blocks.field_150350_a.func_176223_P(), state, 2);
        ModTriggers.FIRST_GRAVE.trigger(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        if (event.getName() == null || event.getLeft().func_190926_b() || event.getRight().func_190926_b()) {
            return;
        }
        if (!event.getName().isEmpty() && event.getRight().func_77973_b().func_206844_a(Tags.Items.INGOTS_IRON) && event.getLeft().func_77973_b() instanceof ItemBlockGrave) {
            ItemStack output = event.getLeft().func_77946_l();
            if (ItemBlockGrave.setEngravedName(output, event.getName())) {
                event.setCost(2);
                event.setOutput(output);
                event.setMaterialCost(1);
            } else {
                EventHandler.cancelAnvilRecipe(event);
            }
        } else if (!event.getName().isEmpty() && ModItems.tablet_of_assistance.isEnchanted(event.getLeft()) && event.getRight().func_77973_b() == ModItems.grave_dust) {
            ItemStack output = event.getLeft().func_77946_l();
            if (ModItems.tablet_of_assistance.setEngravedName(output, event.getName())) {
                event.setCost(2);
                event.setOutput(output);
                event.setMaterialCost(1);
            } else {
                EventHandler.cancelAnvilRecipe(event);
            }
        }
    }

    private static void cancelAnvilRecipe(AnvilUpdateEvent event) {
        event.setCost(0);
        event.setMaterialCost(0);
        event.setOutput(ItemStack.field_190927_a);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilRepair(AnvilRepairEvent event) {
        if (event.getItemInput().func_77973_b() instanceof ItemBlockGrave && event.getIngredientInput().func_77973_b().func_206844_a(Tags.Items.INGOTS_IRON) && ItemBlockGrave.isEngraved(event.getItemResult()) && EntityHelper.isValidPlayerMP((Entity)event.getEntityPlayer())) {
            ModTriggers.ENGRAVE_DECORATIVE_GRAVE.trigger((ServerPlayerEntity)event.getEntityPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void uncancelGraveRightClick(PlayerInteractEvent.RightClickBlock event) {
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        if (block instanceof BlockGrave) {
            if (event.isCanceled()) {
                event.setCanceled(false);
                event.setUseBlock(Event.Result.DEFAULT);
                event.setUseItem(Event.Result.DEFAULT);
            }
            if (event.getWorld().field_72995_K && SpawnProtectionHandler.getInstance().isBlockProtected(Helper.getDimensionId((IWorld)event.getWorld()), event.getPos())) {
                PacketHandler.sendToServer(new TombstoneActivatedMessage(event.getPos()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onUpdateShadowStep(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K || !ConfigTombstone.enchantments.isEnableEnchantmentShadowStep() || !((Boolean)ConfigTombstone.client.showShadowStep.get()).booleanValue() || ConfigTombstone.enchantments.isNerfShadowStep() && !event.getEntity().func_70093_af()) {
            return;
        }
        if (EntityHelper.hasEnchantment(event.getEntityLiving(), ModEnchantments.shadow_step)) {
            ModTombstone.PROXY.produceShadowStep(event.getEntityLiving(), 115.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        if (event.getItem().func_77973_b() == Items.field_151068_bn && EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving()) && PotionUtils.func_185189_a((ItemStack)event.getItem()).size() > 0) {
            CompoundNBT nbt = event.getEntityLiving().getPersistentData();
            nbt.func_74757_a("is_drinking_potion", true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseStop(LivingEntityUseItemEvent.Stop event) {
        if (EventHandler.isDrinking(event.getEntityLiving())) {
            EventHandler.resetDrinking(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (EventHandler.isDrinking(event.getEntityLiving())) {
            EventHandler.resetDrinking(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        Effect potion;
        if (EventHandler.isDrinking(event.getEntityLiving()) && (potion = event.getPotionEffect().func_188419_a()) != null && event.getPotionEffect().field_76460_b > 1200 && potion.getEffect().field_220305_b != EffectType.HARMFUL) {
            assert (potion.getRegistryName() != null);
            if (!((List)ConfigTombstone.general.blackListEffects.get()).contains(potion.getRegistryName().toString())) {
                int bonus = EntityHelper.getPerkLevelWithBonus((PlayerEntity)event.getEntityLiving(), ModPerks.alchemist);
                event.getPotionEffect().field_76460_b = (int)((double)event.getPotionEffect().field_76460_b * (1.0 + (double)bonus / 10.0));
            }
        }
    }

    private static boolean isDrinking(LivingEntity entityLiving) {
        return entityLiving.getPersistentData().func_150297_b("is_drinking_potion", 1);
    }

    private static void resetDrinking(LivingEntity entityLiving) {
        entityLiving.getPersistentData().func_82580_o("is_drinking_potion");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreventFamiliarDeath(LivingDamageEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().func_110143_aJ() <= event.getAmount() && ModItems.familiar_receptacle.captureSoul(event.getEntityLiving())) {
            event.setCanceled(true);
            event.getEntityLiving().remove(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onScaleBeyondTheGraveDamage(LivingDamageEvent event) {
        if (((Boolean)ConfigTombstone.general.allowBeyondTheGraveDamage.get()).booleanValue() && event.getSource() == ModDamages.BEYOND_THE_GRAVE && EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving())) {
            event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                int knowledgeLevel = cap.getTotalPerkPoints();
                if (knowledgeLevel > 0) {
                    event.setAmount(event.getAmount() * (1.0f - (float)Math.min(20, knowledgeLevel) * 0.05f));
                }
            });
        }
    }
}

