/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.api.capability;

import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Perk
extends ForgeRegistryEntry<Perk>
implements Comparable<Perk>,
IStringSerializable {
    protected final String name;
    protected final ResourceLocation icon;

    public Perk(String name, @Nullable ResourceLocation icon) {
        this.name = name;
        this.icon = icon;
    }

    public abstract int getLevelMax();

    public abstract boolean isDisabled();

    @OnlyIn(value=Dist.CLIENT)
    public abstract String getTooltip(int var1, int var2, int var3);

    public abstract int getCost(int var1);

    public boolean isEncrypted() {
        return false;
    }

    public int getLevelBonus(PlayerEntity player) {
        return 0;
    }

    @Nullable
    public ResourceLocation getIcon() {
        return this.icon;
    }

    public String getTranslationKey() {
        return "tombstone.perk." + this.name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getClientTranslation() {
        return I18n.func_135052_a((String)this.getTranslationKey(), (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getSpecialInfo(int levelWithBonus) {
        return "";
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    public boolean equals(Object object) {
        ResourceLocation registryName = this.getRegistryName();
        return registryName != null && object instanceof Perk && registryName.equals((Object)((Perk)object).getRegistryName());
    }

    @Override
    public int compareTo(Perk perk) {
        ResourceLocation registryName = this.getRegistryName();
        ResourceLocation otherRegistryName = perk.getRegistryName();
        if (registryName != null && otherRegistryName != null) {
            return registryName.compareTo(otherRegistryName);
        }
        return registryName == otherRegistryName ? 0 : (registryName == null ? -1 : 1);
    }
}

