/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class PointyTaigaTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState field_181636_a = Blocks.field_196618_L.func_176223_P();
    private static final BlockState field_181637_b = Blocks.field_196645_X.func_176223_P();

    public PointyTaigaTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> p_i51469_1_) {
        super(p_i51469_1_, false);
        this.setSapling((IPlantable)Blocks.field_196675_u);
    }

    @Override
    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox p_208519_5_) {
        int i = rand.nextInt(5) + 7;
        int j = i - rand.nextInt(2) - 3;
        int k = i - j;
        int l = 1 + rand.nextInt(k + 1);
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.getMaxHeight()) {
            boolean flag = true;
            for (int i1 = position.func_177956_o(); i1 <= position.func_177956_o() + 1 + i && flag; ++i1) {
                int j1 = 1;
                j1 = i1 - position.func_177956_o() < j ? 0 : l;
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1 && flag; ++k1) {
                    for (int l1 = position.func_177952_p() - j1; l1 <= position.func_177952_p() + j1 && flag; ++l1) {
                        if (i1 >= 0 && i1 < worldIn.getMaxHeight()) {
                            if (PointyTaigaTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(k1, i1, l1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (PointyTaigaTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, position.func_177977_b(), this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - i - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                int j2 = 0;
                for (int k2 = position.func_177956_o() + i; k2 >= position.func_177956_o() + j; --k2) {
                    for (int i3 = position.func_177958_n() - j2; i3 <= position.func_177958_n() + j2; ++i3) {
                        int j3 = i3 - position.func_177958_n();
                        for (int k3 = position.func_177952_p() - j2; k3 <= position.func_177952_p() + j2; ++k3) {
                            BlockPos blockpos;
                            int i2 = k3 - position.func_177952_p();
                            if (Math.abs(j3) == j2 && Math.abs(i2) == j2 && j2 > 0 || !PointyTaigaTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, blockpos = new BlockPos(i3, k2, k3))) continue;
                            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, blockpos, field_181637_b, p_208519_5_);
                        }
                    }
                    if (j2 >= 1 && k2 == position.func_177956_o() + j + 1) {
                        --j2;
                        continue;
                    }
                    if (j2 >= l) continue;
                    ++j2;
                }
                for (int l2 = 0; l2 < i - 1; ++l2) {
                    if (!PointyTaigaTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, position.func_177981_b(l2))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177981_b(l2), field_181636_a, p_208519_5_);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

