/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class TurtleEggBlock
extends Block {
    private static final VoxelShape field_203172_c = Block.func_208617_a(3.0, 0.0, 3.0, 12.0, 7.0, 12.0);
    private static final VoxelShape field_206843_t = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 7.0, 15.0);
    public static final IntegerProperty field_203170_a = BlockStateProperties.field_208128_ac;
    public static final IntegerProperty field_203171_b = BlockStateProperties.field_208127_ab;

    public TurtleEggBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_203170_a, Integer.valueOf(0)))).func_206870_a((IProperty)field_203171_b, Integer.valueOf(1))));
    }

    @Override
    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.func_203167_a(worldIn, pos, entityIn, 100);
        super.func_176199_a(worldIn, pos, entityIn);
    }

    @Override
    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!(entityIn instanceof ZombieEntity)) {
            this.func_203167_a(worldIn, pos, entityIn, 3);
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    private void func_203167_a(World p_203167_1_, BlockPos p_203167_2_, Entity p_203167_3_, int p_203167_4_) {
        if (!this.func_212570_a(p_203167_1_, p_203167_3_)) {
            super.func_176199_a(p_203167_1_, p_203167_2_, p_203167_3_);
        } else if (!p_203167_1_.field_72995_K && p_203167_1_.field_73012_v.nextInt(p_203167_4_) == 0) {
            this.func_203166_c(p_203167_1_, p_203167_2_, p_203167_1_.func_180495_p(p_203167_2_));
        }
    }

    private void func_203166_c(World p_203166_1_, BlockPos p_203166_2_, BlockState p_203166_3_) {
        p_203166_1_.func_184133_a(null, p_203166_2_, SoundEvents.field_203281_iz, SoundCategory.BLOCKS, 0.7f, 0.9f + p_203166_1_.field_73012_v.nextFloat() * 0.2f);
        int i = (Integer)p_203166_3_.func_177229_b((IProperty)field_203171_b);
        if (i <= 1) {
            p_203166_1_.func_175655_b(p_203166_2_, false);
        } else {
            p_203166_1_.func_180501_a(p_203166_2_, (BlockState)((Object)p_203166_3_.func_206870_a((IProperty)field_203171_b, Integer.valueOf(i - 1))), 2);
            p_203166_1_.func_217379_c(2001, p_203166_2_, Block.func_196246_j(p_203166_3_));
        }
    }

    @Override
    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (this.func_203169_a(worldIn) && this.func_203168_a((IBlockReader)worldIn, pos)) {
            int i = (Integer)state.func_177229_b((IProperty)field_203170_a);
            if (i < 2) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_203280_iy, SoundCategory.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((IProperty)field_203170_a, Integer.valueOf(i + 1))), 2);
            } else {
                worldIn.func_184133_a(null, pos, SoundEvents.field_203279_ix, SoundCategory.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                worldIn.func_217377_a(pos, false);
                if (!worldIn.field_72995_K) {
                    for (int j = 0; j < (Integer)state.func_177229_b((IProperty)field_203171_b); ++j) {
                        worldIn.func_217379_c(2001, pos, Block.func_196246_j(state));
                        TurtleEntity turtleentity = EntityType.field_203099_aq.func_200721_a(worldIn);
                        turtleentity.func_70873_a(-24000);
                        turtleentity.func_203011_g(pos);
                        turtleentity.func_70012_b((double)pos.func_177958_n() + 0.3 + (double)j * 0.2, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.3, 0.0f, 0.0f);
                        worldIn.func_217376_c((Entity)turtleentity);
                    }
                }
            }
        }
    }

    private boolean func_203168_a(IBlockReader p_203168_1_, BlockPos p_203168_2_) {
        return p_203168_1_.func_180495_p(p_203168_2_.func_177977_b()).func_177230_c() == Blocks.field_150354_m;
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.func_203168_a((IBlockReader)worldIn, pos) && !worldIn.field_72995_K) {
            worldIn.func_217379_c(2005, pos, 0);
        }
    }

    private boolean func_203169_a(World p_203169_1_) {
        float f = p_203169_1_.func_72826_c(1.0f);
        if ((double)f < 0.69 && (double)f > 0.65) {
            return true;
        }
        return p_203169_1_.field_73012_v.nextInt(500) == 0;
    }

    @Override
    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        this.func_203166_c(worldIn, pos, state);
    }

    @Override
    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return useContext.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((IProperty)field_203171_b) < 4 ? true : super.func_196253_a(state, useContext);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        return blockstate.func_177230_c() == this ? (BlockState)((Object)blockstate.func_206870_a((IProperty)field_203171_b, Integer.valueOf(Math.min(4, (Integer)blockstate.func_177229_b((IProperty)field_203171_b) + 1)))) : super.func_196258_a(context);
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Integer)state.func_177229_b((IProperty)field_203171_b) > 1 ? field_206843_t : field_203172_c;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_203170_a, field_203171_b});
    }

    private boolean func_212570_a(World worldIn, Entity trampler) {
        if (trampler instanceof TurtleEntity) {
            return false;
        }
        return trampler instanceof LivingEntity && !(trampler instanceof PlayerEntity) ? ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)trampler) : true;
    }
}

