/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;

public class JAOPCAFluidBlock
extends Block
implements IMaterialFormFluidBlock {
    private final IMaterialFormFluid fluid;
    protected final IFluidFormSettings settings;
    protected final StateContainer<Block, BlockState> field_176227_L;
    protected final int maxLevel;
    protected final IntegerProperty levelProperty;
    protected Optional<Material> blockMaterial = Optional.empty();
    protected Optional<MaterialColor> field_181083_K = Optional.empty();
    protected OptionalInt field_149784_t = OptionalInt.empty();
    protected OptionalDouble field_149782_v = OptionalDouble.empty();
    protected OptionalDouble explosionResistance = OptionalDouble.empty();
    protected OptionalInt flammability = OptionalInt.empty();
    protected OptionalInt fireSpreadSpeed = OptionalInt.empty();
    protected Optional<Boolean> isFireSource = Optional.empty();

    public JAOPCAFluidBlock(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(Block.Properties.func_200945_a((Material)Material.field_151586_h).func_200951_a(settings.getLightValueFunction().applyAsInt(fluid.getMaterial())).func_200942_a().func_200944_c().func_222380_e());
        this.fluid = fluid;
        this.settings = settings;
        this.maxLevel = settings.getMaxLevelFunction().applyAsInt(this.getMaterial());
        this.levelProperty = IntegerProperty.func_177719_a((String)"level", (int)0, (int)this.maxLevel);
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_206840_a((StateContainer.Builder<Block, BlockState>)builder);
        this.field_176227_L = builder.func_206893_a(BlockState::new);
        this.func_180632_j((BlockState)this.field_176227_L.func_177621_b());
    }

    @Override
    public IForm getForm() {
        return this.fluid.getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return this.fluid.getMaterial();
    }

    @Override
    public IntegerProperty getLevelProperty() {
        return this.levelProperty;
    }

    public Material func_149688_o(BlockState blockState) {
        if (!this.blockMaterial.isPresent()) {
            this.blockMaterial = Optional.of(this.settings.getMaterialFunction().apply(this.getMaterial()));
        }
        return this.blockMaterial.get();
    }

    public MaterialColor func_180659_g(BlockState blockState, IBlockReader world, BlockPos pos) {
        if (!this.field_181083_K.isPresent()) {
            this.field_181083_K = Optional.of(this.settings.getMaterialColorFunction().apply(this.getMaterial()));
        }
        return this.field_181083_K.get();
    }

    public int getLightValue(BlockState state, IEnviromentBlockReader world, BlockPos pos) {
        if (!this.field_149784_t.isPresent()) {
            this.field_149784_t = OptionalInt.of(this.settings.getLightValueFunction().applyAsInt(this.getMaterial()));
        }
        return this.field_149784_t.getAsInt();
    }

    public float func_176195_g(BlockState blockState, IBlockReader world, BlockPos pos) {
        if (!this.field_149782_v.isPresent()) {
            this.field_149782_v = OptionalDouble.of(this.settings.getBlockHardnessFunction().applyAsDouble(this.getMaterial()));
        }
        return (float)this.field_149782_v.getAsDouble();
    }

    public float func_149638_a() {
        if (!this.explosionResistance.isPresent()) {
            this.explosionResistance = OptionalDouble.of(this.settings.getExplosionResistanceFunction().applyAsDouble(this.getMaterial()));
        }
        return (float)this.explosionResistance.getAsDouble();
    }

    public int getFlammability(BlockState blockState, IBlockReader world, BlockPos pos, Direction face) {
        if (!this.flammability.isPresent()) {
            this.flammability = OptionalInt.of(this.settings.getFireSpreadSpeedFunction().applyAsInt(this.getMaterial()));
        }
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(BlockState blockState, IBlockReader world, BlockPos pos, Direction face) {
        if (!this.fireSpreadSpeed.isPresent()) {
            this.fireSpreadSpeed = OptionalInt.of(this.settings.getFlammabilityFunction().applyAsInt(this.getMaterial()));
        }
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        if (!this.isFireSource.isPresent()) {
            this.isFireSource = Optional.of(this.settings.getIsFireSourceFunction().test(this.getMaterial()));
        }
        return this.isFireSource.get();
    }

    public void func_196265_a(BlockState blockState, World world, BlockPos pos, Random random) {
        world.func_204610_c(pos).func_206891_b(world, pos, random);
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader reader, BlockPos pos) {
        return false;
    }

    public boolean func_196266_a(BlockState blockState, IBlockReader world, BlockPos pos, PathType type) {
        return !this.fluid.asFluid().func_207185_a(FluidTags.field_206960_b);
    }

    public IFluidState func_204507_t(BlockState blockState) {
        IntegerProperty fluidLevelProperty = this.fluid.getLevelProperty();
        int blockLevel = (Integer)blockState.func_177229_b((IProperty)this.levelProperty);
        int fluidLevel = blockLevel >= this.maxLevel ? this.maxLevel + 1 : this.maxLevel - blockLevel;
        return (IFluidState)this.fluid.asFluid().func_207188_f().func_206870_a((IProperty)fluidLevelProperty, (Comparable)Integer.valueOf(fluidLevel));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState blockState, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_204520_s().func_206886_c().func_207187_a(this.fluid.asFluid()) || super.func_200124_e(blockState);
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.INVISIBLE;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Collections.emptyList();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public int func_149738_a(IWorldReader world) {
        return this.fluid.asFluid().func_205569_a(world);
    }

    public void func_220082_b(BlockState blockState, World world, BlockPos pos, BlockState oldBlockState, boolean isMoving) {
        if (this.reactWithNeighbors(world, pos, blockState)) {
            world.func_205219_F_().func_205360_a(pos, (Object)blockState.func_204520_s().func_206886_c(), this.func_149738_a((IWorldReader)world));
        }
    }

    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (blockState.func_204520_s().func_206889_d() || facingState.func_204520_s().func_206889_d()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)blockState.func_204520_s().func_206886_c(), this.func_149738_a((IWorldReader)world));
        }
        return super.func_196271_a(blockState, facing, facingState, world, currentPos, facingPos);
    }

    public void func_220069_a(BlockState blockState, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.reactWithNeighbors(world, pos, blockState)) {
            world.func_205219_F_().func_205360_a(pos, (Object)blockState.func_204520_s().func_206886_c(), this.func_149738_a((IWorldReader)world));
        }
    }

    public boolean reactWithNeighbors(World world, BlockPos pos, BlockState blockState) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        if (this.levelProperty != null) {
            builder.func_206894_a(new IProperty[]{this.levelProperty});
        }
    }

    public StateContainer<Block, BlockState> func_176194_O() {
        return this.field_176227_L;
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, BlockState blockState) {
        if ((Integer)blockState.func_177229_b((IProperty)this.levelProperty) == 0) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            return this.fluid.asFluid();
        }
        return Fluids.field_204541_a;
    }

    public void func_196262_a(BlockState blockState, World world, BlockPos pos, Entity entity) {
        if (this.fluid.asFluid().func_207185_a(FluidTags.field_206960_b)) {
            entity.func_213292_aB();
        }
    }
}

