/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.blocks;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;

public class BlockState2ShortMap {
    private final BiMap<Short, BlockState> shortStateMap;

    public BlockState2ShortMap(BiMap<Short, BlockState> shortStateMap) {
        this.shortStateMap = shortStateMap;
    }

    public BlockState2ShortMap() {
        this((BiMap<Short, BlockState>)HashBiMap.create());
    }

    @Nonnull
    public static BlockState2ShortMap readFromNBT(@Nullable CompoundNBT tagCompound) {
        BlockState2ShortMap mapIntState = new BlockState2ShortMap();
        if (tagCompound == null) {
            return mapIntState;
        }
        mapIntState.readNBT(tagCompound);
        return mapIntState;
    }

    protected BiMap<Short, BlockState> getShortStateMap() {
        return this.shortStateMap;
    }

    public void addToMap(BlockState mapState) {
        if (!this.shortStateMap.containsValue((Object)mapState)) {
            this.shortStateMap.put((Object)((short)this.shortStateMap.size()), (Object)mapState);
        }
    }

    public short getSlot(BlockState mapState) {
        Short res = (Short)this.shortStateMap.inverse().get((Object)mapState);
        return res != null ? (short)res : (short)-1;
    }

    public BlockState getStateFromSlot(short slot) {
        return (BlockState)this.shortStateMap.get((Object)slot);
    }

    public void writeToNBT(@Nonnull CompoundNBT tagCompound) {
        tagCompound.func_218657_a("block_palette", (INBT)this.writeShortStateMapToNBT());
    }

    public void readNBT(@Nonnull CompoundNBT tagCompound) {
        this.clear();
        if (tagCompound.func_74764_b("block_palette")) {
            ListNBT mapIntStateTag = (ListNBT)tagCompound.func_74781_a("block_palette");
            this.readShortStateMapFromNBT(mapIntStateTag);
        }
    }

    public void clear() {
        this.shortStateMap.clear();
    }

    protected ListNBT writeShortStateMapToNBT() {
        ListNBT tagList = new ListNBT();
        for (Map.Entry entry : this.shortStateMap.entrySet()) {
            CompoundNBT compound = new CompoundNBT();
            CompoundNBT state = NBTUtil.func_190009_a((BlockState)((BlockState)entry.getValue()));
            compound.func_74777_a("slot", ((Short)entry.getKey()).shortValue());
            compound.func_218657_a("state", (INBT)state);
            tagList.add((Object)compound);
        }
        return tagList;
    }

    private void readShortStateMapFromNBT(ListNBT tagList) {
        this.shortStateMap.clear();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT compound = tagList.func_150305_b(i);
            this.shortStateMap.put((Object)compound.func_74765_d("slot"), (Object)NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("state")));
        }
    }
}

