/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.blocks;

import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.blocks.BlockState2ShortMap;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItem;
import com.google.common.collect.BiMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;

public final class BlockState2ItemMap
extends BlockState2ShortMap {
    private final Map<BlockState, UniqueItem> stateItemMap;

    public BlockState2ItemMap(BiMap<Short, BlockState> shortStateMap, Map<BlockState, UniqueItem> stateItemMap) {
        super(shortStateMap);
        this.stateItemMap = new HashMap<BlockState, UniqueItem>(stateItemMap);
    }

    public BlockState2ItemMap() {
        this.stateItemMap = new HashMap<BlockState, UniqueItem>();
    }

    public Map<BlockState, UniqueItem> getStateItemMap() {
        return this.stateItemMap;
    }

    @Nonnull
    public static BlockState2ItemMap readFromNBT(@Nullable CompoundNBT tagCompound) {
        BlockState2ItemMap mapIntState = new BlockState2ItemMap();
        if (tagCompound == null) {
            return mapIntState;
        }
        mapIntState.readNBT(tagCompound);
        return mapIntState;
    }

    public void addToMap(UniqueItem uniqueItem, BlockState blockState) {
        this.addToMap(blockState);
        if (!this.stateItemMap.containsValue(uniqueItem)) {
            this.stateItemMap.put(blockState, uniqueItem);
        }
    }

    public UniqueItem getItemForState(BlockState state) {
        return this.stateItemMap.get(state);
    }

    @Override
    public void clear() {
        super.clear();
        this.stateItemMap.clear();
    }

    @Override
    public void writeToNBT(@Nonnull CompoundNBT tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_218657_a("map_int_stack", (INBT)this.writeStateItemMapToNBT());
    }

    @Override
    public void readNBT(@Nonnull CompoundNBT tagCompound) {
        super.readNBT(tagCompound);
        if (tagCompound.func_74764_b("map_int_stack")) {
            ListNBT mapIntStackTag = (ListNBT)tagCompound.func_74781_a("map_int_stack");
            this.readStateItemMapFromNBT(mapIntStackTag);
        }
    }

    public void initStateItemMap(PlayerEntity player) {
        this.stateItemMap.clear();
        for (Map.Entry entry : this.getShortStateMap().entrySet()) {
            try {
                this.stateItemMap.put((BlockState)entry.getValue(), UniqueItem.fromBlockState((BlockState)entry.getValue(), player, new BlockPos(0, 0, 0)));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private ListNBT writeStateItemMapToNBT() {
        ListNBT tagList = new ListNBT();
        for (Map.Entry<BlockState, UniqueItem> entry : this.stateItemMap.entrySet()) {
            CompoundNBT compound = new CompoundNBT();
            entry.getValue().writeToNBT(compound);
            short slot = this.getSlot(entry.getKey());
            if (slot >= 0) {
                compound.func_74777_a("state_id", slot);
            } else {
                compound.func_218657_a("state", (INBT)GadgetUtils.stateToCompound(entry.getKey()));
            }
            tagList.add((Object)compound);
        }
        return tagList;
    }

    private void readStateItemMapFromNBT(ListNBT tagList) {
        this.stateItemMap.clear();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT compound = tagList.func_150305_b(i);
            UniqueItem item = UniqueItem.readFromNBT(compound);
            BlockState state = null;
            if (compound.func_74764_b("state_id")) {
                state = this.getStateFromSlot(compound.func_74765_d("state_id"));
            }
            if (state == null) {
                state = GadgetUtils.compoundToState(compound.func_74775_l("state"));
            }
            this.stateItemMap.put(state, item);
        }
    }
}

