/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tiles;

import com.direwolf20.buildinggadgets.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.registry.objects.BGBlocks;
import com.direwolf20.buildinggadgets.common.registry.objects.BGItems;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TemplateManagerTileEntity
extends TileEntity {
    private static final Set<Item> allowedItemsLeft = ImmutableSet.of((Object)BGItems.gadgetCopyPaste, (Object)BGItems.template);
    private static final Set<Item> allowedItemsRight = ImmutableSet.of((Object)Items.field_151121_aF, (Object)BGItems.template);
    public static final int SIZE = 2;
    private ItemStackHandler itemStackHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TemplateManagerTileEntity.this.func_70296_d();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot == 0) {
                if (!allowedItemsLeft.contains(stack.func_77973_b())) {
                    return stack;
                }
            } else if (slot == 1) {
                if (!allowedItemsRight.contains(stack.func_77973_b())) {
                    return stack;
                }
                if (this.getStackInSlot(slot).func_190916_E() > 0) {
                    return stack;
                }
                if (stack.func_190916_E() > 1) {
                    super.insertItem(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1), simulate);
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1));
                }
            }
            return super.insertItem(slot, stack, simulate);
        }
    };

    public TemplateManagerTileEntity() {
        super(BGBlocks.BGTileEntities.TEMPLATE_MANAGER_TYPE);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT(compound.func_74775_l("items"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("items", (INBT)this.itemStackHandler.serializeNBT());
        return super.func_189515_b(compound);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canInteractWith(PlayerEntity playerIn) {
        if (this.func_145837_r()) return false;
        Vec3d vec3d = new Vec3d((Vec3i)this.field_174879_c);
        if (!(playerIn.func_195048_a(vec3d.func_72441_c(0.5, 0.5, 0.5)) <= 64.0)) return false;
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.itemStackHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public TemplateManagerContainer getContainer(PlayerEntity playerIn) {
        return new TemplateManagerContainer(0, playerIn.field_71071_by, this);
    }
}

