/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry.objects;

import com.direwolf20.buildinggadgets.client.ClientProxy;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="buildinggadgets", bus=Mod.EventBusSubscriber.Bus.MOD)
public enum BGSound {
    BEEP("beep");

    private SoundEvent sound;

    private BGSound(String name) {
        ResourceLocation loc = new ResourceLocation("buildinggadgets", name);
        this.sound = (SoundEvent)new SoundEvent(loc).setRegistryName(name);
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public void playSound() {
        this.playSound(1.0f);
    }

    public void playSound(float pitch) {
        ClientProxy.playSound(this.sound, pitch);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (BGSound sound : BGSound.values()) {
            event.getRegistry().register((IForgeRegistryEntry)sound.getSound());
        }
    }
}

