/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry.block.tile;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.registry.ClientConstructContainer;
import com.direwolf20.buildinggadgets.common.registry.block.tile.TileEntityBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class TileEntityRegistryContainer
extends ClientConstructContainer<TileEntityType<?>, TileEntityBuilder<?>> {
    private Map<ResourceLocation, TileEntityBuilder<?>> reverseMapping = new HashMap();

    @Override
    public void clientInit() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerTERs);
    }

    @Override
    public void add(TileEntityBuilder<?> builder) {
        super.add(builder);
        this.reverseMapping.put(builder.getRegistryName(), builder);
    }

    private void registerTERs(FMLClientSetupEvent event) {
        BuildingGadgets.LOG.info("Registering {} TileEntityRenderer's", (Object)"buildinggadgets");
        int count = 0;
        for (TileEntityBuilder builder : this.getBuilders()) {
            if (!builder.hasRenderer()) continue;
            builder.registerRenderer();
            ++count;
        }
        BuildingGadgets.LOG.info("Finished registering {} {} TileEntityRenderer's", (Object)count, (Object)"buildinggadgets");
    }

    @Nullable
    public TileEntityBuilder<?> getBuilderWithId(ResourceLocation id) {
        return this.reverseMapping.get(Objects.requireNonNull(id));
    }

    @Override
    public void clear() {
        super.clear();
        this.reverseMapping.clear();
    }
}

