/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.registry.RegistryObjectBuilder;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryContainer<T extends IForgeRegistryEntry<T>, B extends RegistryObjectBuilder<T, ?>> {
    private Set<B> builders = new HashSet<B>();

    public void add(B builder) {
        Preconditions.checkArgument((!this.builders.contains(Objects.requireNonNull(builder)) ? 1 : 0) != 0, (Object)"Cannot register builder twice!");
        this.builders.add(builder);
    }

    protected Set<B> getBuilders() {
        return this.builders;
    }

    public void register(RegistryEvent.Register<T> event) {
        BuildingGadgets.LOG.debug("Registering {} objects to {}.", (Object)"buildinggadgets", (Object)event.getName());
        for (RegistryObjectBuilder builder : this.getBuilders()) {
            event.getRegistry().register(builder.construct());
        }
        BuildingGadgets.LOG.debug("Finished Registering {} {} objects to {}.", (Object)this.getBuilders().size(), (Object)"buildinggadgets", (Object)event.getName());
    }

    public void clear() {
        this.builders.clear();
    }
}

