/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.common.capability.CapabilityProviderBlockProvider;
import com.direwolf20.buildinggadgets.common.capability.CapabilityProviderEnergy;
import com.direwolf20.buildinggadgets.common.capability.MultiCapabilityProvider;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.util.CapabilityUtil;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.DistExecutor;

public abstract class AbstractGadget
extends Item {
    private BaseRenderer renderer = (BaseRenderer)DistExecutor.runForDist(this::createRenderFactory, () -> () -> null);

    public AbstractGadget(Item.Properties builder) {
        super(builder);
    }

    public abstract int getEnergyMax();

    public abstract int getEnergyCost(ItemStack var1);

    @OnlyIn(value=Dist.CLIENT)
    public BaseRenderer getRender() {
        return this.renderer;
    }

    protected abstract Supplier<BaseRenderer> createRenderFactory();

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT tag) {
        return new MultiCapabilityProvider(new CapabilityProviderEnergy(stack, this::getEnergyMax), new CapabilityProviderBlockProvider(stack));
    }

    public boolean func_77645_m() {
        return this.func_77612_l() > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return CapabilityUtil.EnergyUtil.returnDoubleIfPresent((ICapabilityProvider)stack, energy -> 1.0 - (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored(), () -> super.getDurabilityForDisplay(stack));
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return CapabilityUtil.EnergyUtil.returnIntIfPresent((ICapabilityProvider)stack, energy -> MathHelper.func_181758_c((float)(Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f), () -> super.getRGBDurabilityForDisplay(stack));
    }

    public boolean isDamaged(ItemStack stack) {
        return CapabilityUtil.EnergyUtil.returnBooleanIfPresent((ICapabilityProvider)stack, energy -> energy.getEnergyStored() != energy.getMaxEnergyStored(), () -> super.isDamaged(stack));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("creative")) {
            return false;
        }
        return CapabilityUtil.EnergyUtil.returnBooleanIfPresent((ICapabilityProvider)stack, energy -> energy.getEnergyStored() != energy.getMaxEnergyStored(), () -> super.showDurabilityBar(stack));
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return !CapabilityUtil.EnergyUtil.hasCap((ICapabilityProvider)toRepair) && repair.func_77973_b() == Items.field_151045_i;
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof AbstractGadget) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof AbstractGadget)) {
            return ItemStack.field_190927_a;
        }
        return heldItem;
    }

    public boolean canUse(ItemStack tool, PlayerEntity player) {
        if (player.func_184812_l_()) {
            return true;
        }
        IEnergyStorage energy = (IEnergyStorage)CapabilityUtil.EnergyUtil.getCap((ICapabilityProvider)tool).orElseThrow(CapabilityNotPresentException::new);
        return this.getEnergyCost(tool) <= energy.getEnergyStored();
    }

    public void applyDamage(ItemStack tool, ServerPlayerEntity player) {
        if (player.func_184812_l_()) {
            return;
        }
        IEnergyStorage energy = (IEnergyStorage)CapabilityUtil.EnergyUtil.getCap((ICapabilityProvider)tool).orElseThrow(CapabilityNotPresentException::new);
        energy.extractEnergy(this.getEnergyCost(tool), false);
    }

    protected void addEnergyInformation(List<ITextComponent> tooltip, ItemStack stack) {
        if (Config.isServerConfigLoaded()) {
            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energy -> tooltip.add(TooltipTranslation.GADGET_ENERGY.componentTranslation(GadgetUtils.withSuffix(energy.getEnergyStored()), GadgetUtils.withSuffix(energy.getMaxEnergyStored())).func_150255_a(Styles.WHITE)));
        }
    }

    public static boolean getFuzzy(ItemStack stack) {
        return NBTHelper.getOrNewTag(stack).func_74767_n("fuzzy");
    }

    public static void toggleFuzzy(PlayerEntity player, ItemStack stack) {
        NBTHelper.getOrNewTag(stack).func_74757_a("fuzzy", !AbstractGadget.getFuzzy(stack));
        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.fuzzymode", new Object[0]).func_150261_e() + ": " + AbstractGadget.getFuzzy(stack)), true);
    }

    public static boolean getConnectedArea(ItemStack stack) {
        return !NBTHelper.getOrNewTag(stack).func_74767_n("unconnected_area");
    }

    public static void toggleConnectedArea(PlayerEntity player, ItemStack stack) {
        NBTHelper.getOrNewTag(stack).func_74757_a("unconnected_area", AbstractGadget.getConnectedArea(stack));
        String suffix = stack.func_77973_b() instanceof GadgetDestruction ? "area" : "surface";
        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.connected" + suffix, new Object[0]).func_150261_e() + ": " + AbstractGadget.getConnectedArea(stack)), true);
    }

    public static boolean shouldRayTraceFluid(ItemStack stack) {
        return NBTHelper.getOrNewTag(stack).func_74767_n("raytrace_fluid");
    }

    public static void toggleRayTraceFluid(ServerPlayerEntity player, ItemStack stack) {
        NBTHelper.getOrNewTag(stack).func_74757_a("raytrace_fluid", !AbstractGadget.shouldRayTraceFluid(stack));
        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent("message.gadget.raytrace_fluid", new Object[0]).func_150261_e() + ": " + AbstractGadget.shouldRayTraceFluid(stack)), true);
    }

    public static void addInformationRayTraceFluid(List<ITextComponent> tooltip, ItemStack stack) {
        tooltip.add(TooltipTranslation.GADGET_RAYTRACE_FLUID.componentTranslation(String.valueOf(AbstractGadget.shouldRayTraceFluid(stack))).func_150255_a(Styles.BLUE));
    }

    protected static String formatName(String name) {
        return name.replaceAll("(?=[A-Z])", " ").trim();
    }
}

