/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.util;

import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.util.DelegatingSpliterator;
import java.util.Spliterator;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;

final class PositionValidatingSpliterator
extends DelegatingSpliterator<BlockPos, BlockPos> {
    private final BiPredicate<BlockPos, BlockData> predicate;
    private final Function<BlockPos, BlockData> dataExtractor;

    public PositionValidatingSpliterator(Spliterator<BlockPos> other, BiPredicate<BlockPos, BlockData> predicate, Function<BlockPos, BlockData> dataExtractor) {
        super(other);
        this.predicate = predicate;
        this.dataExtractor = dataExtractor;
    }

    @Override
    public boolean advance(BlockPos object, Consumer<? super BlockPos> action) {
        BlockData data = this.dataExtractor.apply(object);
        if (this.predicate.test(object, data)) {
            action.accept((BlockPos)object);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Spliterator<BlockPos> trySplit() {
        Spliterator<BlockPos> split = this.getOther().trySplit();
        if (split != null) {
            return new PositionValidatingSpliterator(split, this.predicate, this.dataExtractor);
        }
        return null;
    }
}

