/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.util;

import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

public abstract class DelegatingSpliterator<T, U>
implements Spliterator<U> {
    private final Spliterator<T> other;
    private boolean found;

    protected DelegatingSpliterator(Spliterator<T> other) {
        this.other = Objects.requireNonNull(other);
        this.found = true;
    }

    @Override
    public boolean tryAdvance(Consumer<? super U> action) {
        this.found = false;
        while (this.getOther().tryAdvance((? super T t) -> {
            this.found = this.advance(t, action);
        }) && !this.found) {
        }
        return this.found;
    }

    @Override
    public long estimateSize() {
        return this.getOther().estimateSize();
    }

    @Override
    public int characteristics() {
        return this.getOther().characteristics();
    }

    @Override
    public long getExactSizeIfKnown() {
        return this.getOther().getExactSizeIfKnown();
    }

    protected abstract boolean advance(T var1, Consumer<? super U> var2);

    protected Spliterator<T> getOther() {
        return this.other;
    }
}

