/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.template.transaction;

import com.direwolf20.buildinggadgets.api.building.Region;
import com.direwolf20.buildinggadgets.api.serialisation.TemplateHeader;
import com.direwolf20.buildinggadgets.api.template.transaction.ITransactionExecutionContext;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SimpleTransactionExecutionContext
implements ITransactionExecutionContext {
    private final int size;
    private final Region boundingBox;
    @Nullable
    private final TemplateHeader header;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderOf(ITransactionExecutionContext context) {
        return SimpleTransactionExecutionContext.builder().size(context.getEstimatedTemplateSize()).bounds(context.getBoundingBox()).header(context.getHeader());
    }

    private SimpleTransactionExecutionContext(Region boundingBox, @Nullable TemplateHeader header, @Nonnegative int size) {
        this.size = size;
        this.boundingBox = Objects.requireNonNull(boundingBox, "Cannot construct a TransactionExecutionContext with a null BoundingBox!");
        this.header = header;
    }

    @Override
    public int getEstimatedTemplateSize() {
        return this.size;
    }

    @Override
    public Region getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    @Nullable
    public TemplateHeader getHeader() {
        return this.header;
    }

    public static final class Builder {
        private int size = -1;
        private Region boundingBox;
        private TemplateHeader header;

        private Builder() {
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder bounds(Region boundingBox) {
            this.boundingBox = Objects.requireNonNull(boundingBox);
            return this;
        }

        public Builder header(@Nullable TemplateHeader header) {
            this.header = header;
            return this;
        }

        public SimpleTransactionExecutionContext build() {
            return this.build(null);
        }

        public SimpleTransactionExecutionContext build(@Nullable Region boundingBox) {
            if (boundingBox != null) {
                this.boundingBox = boundingBox;
            }
            return new SimpleTransactionExecutionContext(this.boundingBox, this.header, this.size);
        }
    }
}

