/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.template;

import com.direwolf20.buildinggadgets.api.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.api.template.IBuildOpenOptions;
import java.util.Objects;

public final class SimpleBuildOpenOptions
implements IBuildOpenOptions {
    private final IBuildContext buildContext;
    private final IBuildOpenOptions.OpenType openType;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderCopyOf(IBuildOpenOptions openOptions) {
        return SimpleBuildOpenOptions.builder().context(openOptions.getContext()).openType(openOptions.getOpenType());
    }

    public static SimpleBuildOpenOptions copyOf(IBuildOpenOptions openOptions) {
        return SimpleBuildOpenOptions.builderCopyOf(openOptions).build();
    }

    private SimpleBuildOpenOptions(IBuildContext buildContext, IBuildOpenOptions.OpenType openType) {
        this.buildContext = buildContext;
        this.openType = openType;
    }

    @Override
    public IBuildContext getContext() {
        return this.buildContext;
    }

    @Override
    public IBuildOpenOptions.OpenType getOpenType() {
        return this.openType;
    }

    public static final class Builder {
        private IBuildContext buildContext = null;
        private IBuildOpenOptions.OpenType openType = null;

        private Builder() {
        }

        public Builder context(IBuildContext context) {
            this.buildContext = context;
            return this;
        }

        public Builder openType(IBuildOpenOptions.OpenType openType) {
            this.openType = openType;
            return this;
        }

        public SimpleBuildOpenOptions build() {
            return new SimpleBuildOpenOptions(Objects.requireNonNull(this.buildContext, "Cannot have a null IBuildContext!"), this.openType != null ? this.openType : IBuildOpenOptions.OpenType.DEFAULT);
        }
    }
}

