/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.template;

import com.direwolf20.buildinggadgets.api.APIReference;
import com.direwolf20.buildinggadgets.api.building.BlockData;
import com.direwolf20.buildinggadgets.api.building.PlacementTarget;
import com.direwolf20.buildinggadgets.api.building.Region;
import com.direwolf20.buildinggadgets.api.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.api.building.view.IBuildView;
import com.direwolf20.buildinggadgets.api.exceptions.TransactionExecutionException;
import com.direwolf20.buildinggadgets.api.exceptions.TransactionResultExceedsTemplateSizeException;
import com.direwolf20.buildinggadgets.api.materials.MaterialList;
import com.direwolf20.buildinggadgets.api.materials.UniqueItem;
import com.direwolf20.buildinggadgets.api.serialisation.ITemplateSerializer;
import com.direwolf20.buildinggadgets.api.serialisation.SerialisationSupport;
import com.direwolf20.buildinggadgets.api.serialisation.TemplateHeader;
import com.direwolf20.buildinggadgets.api.template.IBuildOpenOptions;
import com.direwolf20.buildinggadgets.api.template.ITemplate;
import com.direwolf20.buildinggadgets.api.template.transaction.AbsTemplateTransaction;
import com.direwolf20.buildinggadgets.api.template.transaction.ITemplateTransaction;
import com.direwolf20.buildinggadgets.api.template.transaction.ITransactionExecutionContext;
import com.direwolf20.buildinggadgets.api.template.transaction.SimpleTransactionExecutionContext;
import com.direwolf20.buildinggadgets.api.util.CommonUtils;
import com.direwolf20.buildinggadgets.api.util.DelegatingSpliterator;
import com.direwolf20.buildinggadgets.api.util.MathUtils;
import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.registries.ForgeRegistryEntry;

@Immutable
public final class ImmutableTemplate
implements ITemplate {
    private final Long2IntMap posToStateId;
    private final BlockData[] idToData;
    private final TemplateHeader headerInfo;

    public static ImmutableTemplate create() {
        return new ImmutableTemplate();
    }

    private ImmutableTemplate(Long2IntMap posToStateId, BlockData[] idToData, TemplateHeader headerInfo) {
        this.posToStateId = Objects.requireNonNull(posToStateId);
        this.idToData = Objects.requireNonNull(idToData);
        this.headerInfo = Objects.requireNonNull(headerInfo);
    }

    private ImmutableTemplate() {
        this((Long2IntMap)new Long2IntOpenHashMap(), new BlockData[0], TemplateHeader.builder(APIReference.TemplateSerializerReference.IMMUTABLE_TEMPLATE_SERIALIZER_RL, Region.singleZero()).build());
    }

    @Override
    public ITemplateTransaction startTransaction() {
        return new TemplateTransaction(this.posToStateId, this.idToData, this.headerInfo);
    }

    @Override
    public ITemplateSerializer getSerializer() {
        return SerialisationSupport.immutableTemplateSerializer();
    }

    @Override
    public IBuildView createViewInContext(IBuildOpenOptions openOptions) {
        return new BuildView(openOptions.getContext(), this.posToStateId, this.idToData, this.headerInfo);
    }

    private Long2IntMap getPosToStateId() {
        return this.posToStateId;
    }

    private BlockData[] getIdToData() {
        return this.idToData;
    }

    private TemplateHeader getHeaderInfo() {
        return this.headerInfo;
    }

    private static final class TemplateTransaction
    extends AbsTemplateTransaction {
        private static final int PARALLEL_THRESHOLD = 512;
        private static final int INVERSE_B1_MASK = -256;
        private static final int INVERSE_B2_MASK = -65536;
        private static final int INVERSE_B3_MASK = -16777216;
        private Long2IntMap posToStateId;
        private BlockData[] idToData;
        private TemplateHeader headerInfo;
        @Nullable
        private Map<BlockPos, BlockData> posToData;
        @Nullable
        private Map<BlockData, Set<BlockPos>> dataToPos;

        public TemplateTransaction(Long2IntMap posToStateId, BlockData[] idToData, TemplateHeader headerInfo) {
            this.posToStateId = posToStateId;
            this.idToData = idToData;
            this.headerInfo = headerInfo;
            this.posToData = null;
            this.dataToPos = null;
        }

        @Override
        protected ITransactionExecutionContext createContext() {
            return SimpleTransactionExecutionContext.builder().size(this.posToData != null ? this.posToData.size() : this.posToStateId.size()).header(this.headerInfo).build(this.headerInfo.getBoundingBox());
        }

        @Override
        protected void mergeCreated(ITransactionExecutionContext exContext, AbsTemplateTransaction.OperatorOrdering ordering, Map<BlockPos, BlockData> created) {
            this.ensureReverseMappingCreated();
            assert (this.posToData != null);
            assert (this.dataToPos != null);
            Region.Builder builder = Region.enclosingBuilder().enclose(this.headerInfo.getBoundingBox());
            for (Map.Entry<BlockPos, BlockData> entry : created.entrySet()) {
                BlockData cur = this.posToData.get(entry.getKey());
                this.posToData.put(entry.getKey(), entry.getValue());
                Set positions = this.dataToPos.computeIfAbsent(entry.getValue(), k -> new HashSet());
                positions.add(entry.getKey());
                if (cur != null) {
                    Set<BlockPos> curPositions = this.dataToPos.get(cur);
                    assert (curPositions != null);
                    if (curPositions.size() <= 1) {
                        this.dataToPos.remove(cur);
                    } else {
                        curPositions.remove(entry.getKey());
                    }
                }
                builder.enclose((Vec3i)entry.getKey());
            }
            this.headerInfo = TemplateHeader.builderOf(this.headerInfo).bounds(builder.build()).build();
        }

        @Override
        protected void transformAllData(ITransactionExecutionContext exContext, AbsTemplateTransaction.OperatorOrdering ordering, AbsTemplateTransaction.DataTransformer dataTransformer) throws TransactionExecutionException {
            this.ensureReverseMappingCreated();
            assert (this.posToData != null);
            assert (this.dataToPos != null);
            HashMap<BlockData, Set<BlockPos>> newDataToPositionMapping = new HashMap<BlockData, Set<BlockPos>>();
            for (Map.Entry<BlockData, Set<BlockPos>> entry : this.dataToPos.entrySet()) {
                BlockData newData = dataTransformer.transformData(entry.getKey());
                if (newData != null) {
                    Set positions = newDataToPositionMapping.computeIfAbsent(newData, k -> new HashSet());
                    positions.addAll((Collection)entry.getValue());
                    if (newData.equals(entry.getKey())) continue;
                    for (BlockPos pos : entry.getValue()) {
                        this.posToData.put(pos, newData);
                    }
                    continue;
                }
                Stream.concat(newDataToPositionMapping.getOrDefault(entry.getKey(), Collections.emptySet()).stream(), entry.getValue().stream()).forEach(p -> this.posToData.remove(p));
            }
            this.dataToPos = newDataToPositionMapping;
        }

        @Override
        protected void transformAllPositions(ITransactionExecutionContext exContext, AbsTemplateTransaction.OperatorOrdering ordering, AbsTemplateTransaction.PositionTransformer positionTransformer) throws TransactionExecutionException {
            this.ensureReverseMappingCreated();
            assert (this.posToData != null);
            assert (this.dataToPos != null);
            HashMap<BlockPos, BlockData> newPosToDataMap = new HashMap<BlockPos, BlockData>();
            Region.Builder builder = Region.enclosingBuilder();
            for (Map.Entry<BlockPos, BlockData> entry : this.posToData.entrySet()) {
                BlockPos newPos = positionTransformer.transformPos(entry.getKey(), entry.getValue());
                Set<BlockPos> positions = this.dataToPos.get(entry.getValue());
                assert (positions != null && !positions.isEmpty());
                positions.remove(entry.getKey());
                if (newPos != null) {
                    newPosToDataMap.put(newPos, entry.getValue());
                    positions.add(newPos);
                    builder.enclose((Vec3i)newPos);
                    continue;
                }
                if (!positions.isEmpty()) continue;
                this.dataToPos.remove(entry.getValue());
            }
            if (!this.posToData.isEmpty()) {
                this.headerInfo = TemplateHeader.builderOf(this.headerInfo).bounds(builder.build()).build();
            }
            this.posToData = newPosToDataMap;
        }

        @Override
        protected void transformAllTargets(ITransactionExecutionContext exContext, AbsTemplateTransaction.OperatorOrdering ordering, AbsTemplateTransaction.TargetTransformer targetTransformer) throws TransactionExecutionException {
            this.ensureReverseMappingCreated();
            assert (this.posToData != null);
            HashMap<BlockPos, BlockData> newPosToDataMap = new HashMap<BlockPos, BlockData>();
            HashMap<BlockData, Set<BlockPos>> newDataToPositionMapping = new HashMap<BlockData, Set<BlockPos>>();
            Region.Builder builder = Region.enclosingBuilder();
            for (Map.Entry<BlockPos, BlockData> entry : this.posToData.entrySet()) {
                PlacementTarget target = targetTransformer.transformTarget(new PlacementTarget(entry.getKey(), entry.getValue()));
                if (target == null) continue;
                newPosToDataMap.put(target.getPos(), target.getData());
                newDataToPositionMapping.computeIfAbsent(target.getData(), k -> new HashSet()).add(target.getPos());
                builder.enclose((Vec3i)target.getPos());
            }
            if (!this.posToData.isEmpty()) {
                this.headerInfo = TemplateHeader.builderOf(this.headerInfo).bounds(builder.build()).build();
            }
            this.posToData = newPosToDataMap;
            this.dataToPos = newDataToPositionMapping;
        }

        @Override
        protected void updateHeader(ITransactionExecutionContext exContext, AbsTemplateTransaction.OperatorOrdering ordering, AbsTemplateTransaction.HeaderTransformer transformer) throws TransactionExecutionException {
            this.headerInfo = transformer.transformHeader(this.headerInfo);
        }

        @Override
        protected ITemplate createTemplate(ITransactionExecutionContext exContext, Queue<AbsTemplateTransaction.OperatorOrdering> orderings, @Nullable IBuildContext context, boolean changed) throws TransactionExecutionException {
            boolean cannotAddRequiredItems;
            if (!changed) {
                return new ImmutableTemplate(this.posToStateId, this.idToData, this.headerInfo);
            }
            boolean hasNoDataChange = orderings.stream().allMatch(ordering -> ordering.getDataCreators().isEmpty() && ordering.getTargetTransformers().isEmpty() && ordering.getDataTransformers().isEmpty() && ordering.getPositionTransformers().isEmpty());
            boolean bl = cannotAddRequiredItems = context == null || this.headerInfo.getRequiredItems() != null;
            if (!hasNoDataChange) {
                assert (this.posToData != null);
                this.posToStateId = new Long2IntOpenHashMap(this.posToData.size());
                this.createPosToState(this.createIdToData(), context);
            } else if (!cannotAddRequiredItems) {
                this.updateRequiredItems(context);
            }
            return new ImmutableTemplate(this.posToStateId, this.idToData, this.headerInfo);
        }

        private void ensureReverseMappingCreated() {
            if (this.posToData != null && this.dataToPos != null) {
                return;
            }
            this.posToData = new HashMap<BlockPos, BlockData>(this.posToStateId.size());
            this.dataToPos = new HashMap<BlockData, Set<BlockPos>>(this.idToData.length);
            for (Long2IntMap.Entry entry : this.posToStateId.long2IntEntrySet()) {
                BlockPos pos = MathUtils.posFromLong(entry.getLongKey());
                BlockData data = this.idToData[entry.getIntValue()];
                this.posToData.put(pos, data);
                Set positions = this.dataToPos.computeIfAbsent(data, k -> new HashSet());
                positions.add(pos);
            }
            this.posToStateId = null;
            this.idToData = null;
        }

        private Object2IntMap<BlockData> createIdToData() throws TransactionExecutionException {
            assert (this.dataToPos != null);
            this.idToData = new BlockData[this.dataToPos.size()];
            Object2IntOpenHashMap reverse = new Object2IntOpenHashMap(this.dataToPos.size());
            int curId = 0;
            for (BlockData data : this.dataToPos.keySet()) {
                if ((curId & 0xFF000000) != 0) {
                    throw new TransactionResultExceedsTemplateSizeException.ToManyDifferentBlockDataInstances("Cannot have more then 2^24 different types (24-bit id's) of BlockData in one ImmutableTemplate!", (ITemplateTransaction)this);
                }
                this.idToData[curId] = data;
                reverse.put((Object)data, curId++);
            }
            this.dataToPos = null;
            return reverse;
        }

        private void createPosToState(Object2IntMap<BlockData> reverseMap, @Nullable IBuildContext context) throws TransactionExecutionException {
            assert (this.posToData != null);
            this.posToStateId = new Long2IntOpenHashMap(this.posToData.size());
            MaterialList.Builder builder = context != null ? MaterialList.builder() : null;
            Region.Builder regionBuilder = Region.enclosingBuilder();
            BlockPos smallest = this.headerInfo.getBoundingBox().getMin();
            for (Map.Entry<BlockPos, BlockData> entry : this.posToData.entrySet()) {
                BlockPos resPos = this.validatePos(entry.getKey().func_177973_b((Vec3i)smallest));
                this.posToStateId.put(MathUtils.posToLong(resPos), reverseMap.getInt((Object)entry.getValue()));
                if (context != null) {
                    PlacementTarget target = new PlacementTarget(resPos, entry.getValue());
                    PlayerEntity player = context.getBuildingPlayer();
                    BlockRayTraceResult targetRes = player != null ? CommonUtils.fakeRayTrace(player.field_70165_t, player.field_70163_u, player.field_70161_v, resPos) : null;
                    builder.addAll((Collection<UniqueItem>)target.getRequiredItems(context, (RayTraceResult)targetRes).getRequiredItems());
                }
                regionBuilder.enclose((Vec3i)resPos);
            }
            Region region = regionBuilder.build();
            assert (region.getMin().equals((Object)BlockPos.field_177992_a));
            this.headerInfo = TemplateHeader.builderOf(this.headerInfo).bounds(region).requiredItems(builder != null ? builder.build() : null).build();
        }

        private BlockPos.MutableBlockPos getSmallest() {
            assert (this.posToData != null);
            Set<BlockPos> keySet = this.posToData.keySet();
            return (keySet.size() >= 512 ? keySet.parallelStream() : keySet.stream()).collect(Collector.of(() -> new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), (mutable, pos) -> {
                mutable.func_223471_o(Math.min(mutable.func_177958_n(), pos.func_177958_n()));
                mutable.func_185336_p(Math.min(mutable.func_177956_o(), pos.func_177956_o()));
                mutable.func_185336_p(Math.min(mutable.func_177952_p(), pos.func_177952_p()));
            }, (m1, m2) -> new BlockPos.MutableBlockPos(Math.min(m1.func_177958_n(), m2.func_177958_n()), Math.min(m1.func_177956_o(), m2.func_177956_o()), Math.min(m1.func_177952_p(), m2.func_177952_p())), Collector.Characteristics.UNORDERED));
        }

        private BlockPos validatePos(BlockPos resPos) throws TransactionExecutionException {
            if ((resPos.func_177958_n() & 0xFFFF0000) != 0) {
                throw new TransactionResultExceedsTemplateSizeException.BlockPosOutOfBounds("X-Coordinate of " + resPos + " exceeds maximum X-Size of " + 65535 + " (16-Bit)!", (ITemplateTransaction)this, resPos);
            }
            if ((resPos.func_177956_o() & 0xFFFFFF00) != 0) {
                throw new TransactionResultExceedsTemplateSizeException.BlockPosOutOfBounds("Y-Coordinate of " + resPos + " exceeds maximum Y-Size of " + 255 + " (8-Bit)!", (ITemplateTransaction)this, resPos);
            }
            if ((resPos.func_177952_p() & 0xFFFF0000) != 0) {
                throw new TransactionResultExceedsTemplateSizeException.BlockPosOutOfBounds("Z-Coordinate of " + resPos + " exceeds maximum Z-Size of " + 65535 + " (16-Bit)!", (ITemplateTransaction)this, resPos);
            }
            return resPos;
        }

        private void updateRequiredItems(IBuildContext context) {
            assert (this.posToStateId != null);
            this.headerInfo = TemplateHeader.builderOf(this.headerInfo).requiredItems(CommonUtils.estimateRequiredItems(() -> {
                ObjectIterator iterator = this.posToStateId.long2IntEntrySet().iterator();
                return new AbstractIterator<PlacementTarget>((Iterator)iterator){
                    final /* synthetic */ Iterator val$iterator;
                    {
                        this.val$iterator = iterator;
                    }

                    protected PlacementTarget computeNext() {
                        if (!this.val$iterator.hasNext()) {
                            return (PlacementTarget)this.endOfData();
                        }
                        Long2IntMap.Entry entry = (Long2IntMap.Entry)this.val$iterator.next();
                        BlockPos pos = MathUtils.posFromLong(entry.getLongKey());
                        BlockData data = idToData[entry.getIntValue()];
                        return new PlacementTarget(pos, data);
                    }
                };
            }, context)).build();
        }
    }

    private static final class BuildView
    implements IBuildView {
        private final IBuildContext context;
        private final Long2IntMap posToStateId;
        private final BlockData[] idToData;
        private TemplateHeader headerInfo;
        private BlockPos translation;

        private BuildView(IBuildContext context, Long2IntMap posToStateId, BlockData[] idToData, TemplateHeader headerInfo) {
            this.context = context;
            this.posToStateId = posToStateId;
            this.idToData = idToData;
            this.headerInfo = headerInfo;
            this.translation = BlockPos.field_177992_a;
        }

        @Override
        public Spliterator<PlacementTarget> spliterator() {
            return new BuildSpliterator(this.posToStateId.long2IntEntrySet().spliterator(), this.idToData);
        }

        @Override
        public IBuildView translateTo(BlockPos pos) {
            this.translation = pos;
            return this;
        }

        @Override
        public int estimateSize() {
            return this.posToStateId.size();
        }

        @Override
        public void close() {
        }

        @Override
        public IBuildView copy() {
            return new BuildView(this.context, this.posToStateId, this.idToData, this.headerInfo).translateTo(this.translation);
        }

        @Override
        public IBuildContext getContext() {
            return this.context;
        }

        @Override
        public Region getBoundingBox() {
            return this.headerInfo.getBoundingBox();
        }

        @Override
        public boolean mayContain(int x, int y, int z) {
            BlockPos pos = new BlockPos(x - this.translation.func_177958_n(), y - this.translation.func_177956_o(), z - this.translation.func_177952_p());
            return this.posToStateId.containsKey(MathUtils.posToLong(pos));
        }

        @Override
        public MaterialList estimateRequiredItems(@Nullable Vec3d simulatePos) {
            if (this.headerInfo.getRequiredItems() == null) {
                this.headerInfo = TemplateHeader.builderOf(this.headerInfo).requiredItems(IBuildView.super.estimateRequiredItems(simulatePos)).build();
            }
            assert (this.headerInfo.getRequiredItems() != null);
            return this.headerInfo.getRequiredItems();
        }

        private static final class BuildSpliterator
        extends DelegatingSpliterator<Long2IntMap.Entry, PlacementTarget> {
            private final BlockData[] idToData;

            public BuildSpliterator(Spliterator<Long2IntMap.Entry> idSpliterator, BlockData[] idToData) {
                super(idSpliterator);
                this.idToData = idToData;
            }

            @Override
            @Nullable
            public Spliterator<PlacementTarget> trySplit() {
                Spliterator<Long2IntMap.Entry> split = this.getOther().trySplit();
                if (split != null) {
                    return new BuildSpliterator(split, this.idToData);
                }
                return null;
            }

            @Override
            protected boolean advance(Long2IntMap.Entry object, Consumer<? super PlacementTarget> action) {
                BlockPos constructed = MathUtils.posFromLong(object.getLongKey());
                BlockData data = this.idToData[object.getIntValue()];
                action.accept(new PlacementTarget(constructed, data));
                return true;
            }
        }
    }

    public static final class Serializer
    extends ForgeRegistryEntry<ITemplateSerializer>
    implements ITemplateSerializer {
        @Override
        public TemplateHeader createHeaderFor(ITemplate template) {
            ImmutableTemplate castTemplate = (ImmutableTemplate)template;
            return castTemplate.getHeaderInfo();
        }

        @Override
        public CompoundNBT serialize(ITemplate template, boolean persisted) {
            CompoundNBT nbt = new CompoundNBT();
            ImmutableTemplate castTemplate = (ImmutableTemplate)template;
            BlockData[] idToData = castTemplate.getIdToData();
            Long2IntMap posToStateId = castTemplate.getPosToStateId();
            TemplateHeader header = castTemplate.getHeaderInfo();
            ListNBT dataList = new ListNBT();
            long[] posAndId = new long[posToStateId.size()];
            for (BlockData entry : idToData) {
                dataList.add((Object)entry.serialize(persisted));
            }
            int index = 0;
            for (Long2IntMap.Entry entry : posToStateId.long2IntEntrySet()) {
                posAndId[index++] = MathUtils.includeStateId(entry.getLongKey(), entry.getIntValue());
            }
            nbt.func_218657_a("data", (INBT)dataList);
            nbt.func_197644_a("pos", posAndId);
            nbt.func_218657_a("header", (INBT)header.toNBT(persisted));
            return nbt;
        }

        @Override
        public ITemplate deserialize(CompoundNBT tagCompound, @Nullable TemplateHeader header, boolean persisted) {
            long[] posAndId = tagCompound.func_197645_o("pos");
            ListNBT dataList = tagCompound.func_150295_c("data", 10);
            header = TemplateHeader.fromNBT(tagCompound.func_74775_l("header"));
            BlockData[] idToData = new BlockData[dataList.size()];
            Long2IntOpenHashMap posToStateId = new Long2IntOpenHashMap(posAndId.length);
            int index = 0;
            for (INBT nbt : dataList) {
                if (!(nbt instanceof CompoundNBT)) {
                    throw new IllegalArgumentException("Found corrupted Template save! Expected " + nbt + " to be an instance of " + CompoundNBT.class.getName() + "!");
                }
                idToData[index++] = BlockData.deserialize((CompoundNBT)nbt, persisted);
            }
            for (Object l : (Object)posAndId) {
                int stateId = MathUtils.readStateId((long)l);
                long serializedPos = MathUtils.readSerializedPos((long)l);
                if (stateId < 0 || stateId >= idToData.length) {
                    throw new IllegalArgumentException("Found corrupted Template save! " + stateId + " is not a vaild state id! Should be in range [" + 0 + ", " + idToData.length + "]");
                }
                posToStateId.put(serializedPos, stateId);
            }
            return new ImmutableTemplate((Long2IntMap)posToStateId, idToData, header);
        }
    }
}

