/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.materials;

import com.direwolf20.buildinggadgets.api.materials.UniqueItem;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.Collection;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public final class MaterialList {
    private static final MaterialList EMPTY = new MaterialList();
    private final ImmutableMultiset<UniqueItem> requiredItems;

    public static MaterialList deserialize(CompoundNBT nbt) {
        return MaterialList.deserializeBuilder(nbt).build();
    }

    public static Builder deserializeBuilder(CompoundNBT nbt) {
        Builder builder = MaterialList.builder();
        ListNBT nbtList = nbt.func_150295_c("data", 10);
        for (INBT nbtEntry : nbtList) {
            CompoundNBT compoundEntry = (CompoundNBT)nbtEntry;
            builder.addItem(UniqueItem.deserialize(compoundEntry.func_74775_l("data")), compoundEntry.func_74762_e("count"));
        }
        return builder;
    }

    public static MaterialList empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder();
    }

    private MaterialList() {
        this((Multiset<UniqueItem>)ImmutableMultiset.of());
    }

    private MaterialList(Multiset<UniqueItem> requiredItems) {
        this.requiredItems = ImmutableMultiset.copyOf(requiredItems);
    }

    public ImmutableMultiset<UniqueItem> getRequiredItems() {
        return this.requiredItems;
    }

    public CompoundNBT serialize(boolean persisted) {
        CompoundNBT res = new CompoundNBT();
        ListNBT nbtList = new ListNBT();
        for (Multiset.Entry entry : this.requiredItems.entrySet()) {
            CompoundNBT nbtEntry = new CompoundNBT();
            nbtEntry.func_218657_a("data", (INBT)((UniqueItem)entry.getElement()).serialize(persisted));
            nbtEntry.func_74768_a("count", entry.getCount());
            nbtList.add((Object)nbtEntry);
        }
        res.func_218657_a("data", (INBT)nbtList);
        return res;
    }

    public static final class Builder {
        private Multiset<UniqueItem> requiredItems = HashMultiset.create();

        private Builder() {
        }

        public Builder addItem(UniqueItem item, int count) {
            this.requiredItems.add((Object)item, count);
            return this;
        }

        public Builder addItem(UniqueItem item) {
            return this.addItem(item, 1);
        }

        public Builder addAll(Collection<UniqueItem> items) {
            this.requiredItems.addAll(items);
            return this;
        }

        public MaterialList build() {
            return new MaterialList(this.requiredItems);
        }
    }
}

