/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api.building.placement;

import com.direwolf20.buildinggadgets.api.building.Region;
import com.direwolf20.buildinggadgets.api.building.placement.IPositionPlacementSequence;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

final class SurfaceSequence
implements IPositionPlacementSequence {
    private final IBlockReader world;
    private final BlockState selectedBase;
    private final Function<BlockPos, BlockPos> searching2referenceMapper;
    private final Region searchingRegion;
    private final boolean fuzzy;

    @VisibleForTesting
    SurfaceSequence(IBlockReader world, BlockPos center, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, boolean fuzzy) {
        this(world, world.func_180495_p(searching2referenceMapper.apply(center)), searching2referenceMapper, searchingRegion, fuzzy);
    }

    SurfaceSequence(IBlockReader world, BlockState selectedBase, Function<BlockPos, BlockPos> searching2referenceMapper, Region searchingRegion, boolean fuzzy) {
        this.world = world;
        this.selectedBase = selectedBase;
        this.searching2referenceMapper = searching2referenceMapper;
        this.searchingRegion = searchingRegion;
        this.fuzzy = fuzzy;
    }

    @Override
    public Region getBoundingBox() {
        return this.searchingRegion;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.searchingRegion.contains(x, y, z);
    }

    @Override
    public IPositionPlacementSequence copy() {
        return new SurfaceSequence(this.world, this.selectedBase, this.searching2referenceMapper, this.searchingRegion, this.fuzzy);
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        return new AbstractIterator<BlockPos>(){
            private final Iterator<BlockPos> it;
            {
                this.it = SurfaceSequence.this.searchingRegion.iterator();
            }

            protected BlockPos computeNext() {
                while (this.it.hasNext()) {
                    BlockPos pos = this.it.next();
                    BlockPos referencePos = (BlockPos)SurfaceSequence.this.searching2referenceMapper.apply(pos);
                    BlockState baseBlock = SurfaceSequence.this.world.func_180495_p(referencePos);
                    if (!SurfaceSequence.this.fuzzy && baseBlock != SurfaceSequence.this.selectedBase || baseBlock.func_177230_c().isAir(baseBlock, SurfaceSequence.this.world, referencePos)) continue;
                    return pos;
                }
                return (BlockPos)this.endOfData();
            }
        };
    }
}

