/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.api;

import com.direwolf20.buildinggadgets.api.APIReference;
import com.direwolf20.buildinggadgets.api.BuildingGadgetsAPI;
import com.direwolf20.buildinggadgets.api.building.tilesupport.ITileDataFactory;
import com.direwolf20.buildinggadgets.api.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.api.registry.IOrderedRegistry;
import com.direwolf20.buildinggadgets.api.registry.TopologicalRegistryBuilder;
import com.direwolf20.buildinggadgets.api.serialisation.ITemplateSerializer;
import com.direwolf20.buildinggadgets.api.serialisation.ITileDataSerializer;
import com.direwolf20.buildinggadgets.api.serialisation.SerialisationSupport;
import com.direwolf20.buildinggadgets.api.template.DelegatingTemplate;
import com.direwolf20.buildinggadgets.api.template.ImmutableTemplate;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="buildinggadgets", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Registries {
    private static TopologicalRegistryBuilder<ITileDataFactory> tileDataFactoryBuilder = TopologicalRegistryBuilder.create();
    private static IForgeRegistry<ITemplateSerializer> templateSerializers = null;
    private static IForgeRegistry<ITileDataSerializer> tileDataSerializers = null;
    private static IOrderedRegistry<ITileDataFactory> tileDataFactories = null;

    private Registries() {
    }

    public static IForgeRegistry<ITemplateSerializer> getTemplateSerializers() {
        Preconditions.checkState((templateSerializers != null ? 1 : 0) != 0, (Object)"Attempted to retrieve TemplateSerializerRegistry before registries were created!");
        return templateSerializers;
    }

    static void onCreateRegistries() {
        BuildingGadgetsAPI.LOG.trace("Creating ForgeRegistries");
        templateSerializers = new RegistryBuilder().setType(ITemplateSerializer.class).setName(APIReference.TemplateSerializerReference.REGISTRY_ID_TEMPLATE_SERIALIZER).create();
        tileDataSerializers = new RegistryBuilder().setType(ITileDataSerializer.class).setName(APIReference.TileDataSerializerReference.REGISTRY_ID_TILE_DATA_SERIALIZER).create();
        BuildingGadgetsAPI.LOG.trace("Finished Creating ForgeRegistries");
    }

    @SubscribeEvent
    public static void registerTemplateSerializers(RegistryEvent.Register<ITemplateSerializer> event) {
        BuildingGadgetsAPI.LOG.trace("Registering Template Serializers");
        event.getRegistry().register(new ImmutableTemplate.Serializer().setRegistryName(APIReference.TemplateSerializerReference.IMMUTABLE_TEMPLATE_SERIALIZER_RL));
        event.getRegistry().register(new DelegatingTemplate.DelegatingTemplateSerializer().setRegistryName(APIReference.TemplateSerializerReference.DELEGATING_TEMPLATE_SERIALIZER_RL));
        BuildingGadgetsAPI.LOG.trace("Finished Registering Template Serializers");
    }

    @SubscribeEvent
    public static void registerTileDataSerializers(RegistryEvent.Register<ITileDataSerializer> event) {
        BuildingGadgetsAPI.LOG.trace("Registering Template Serializers");
        event.getRegistry().register((IForgeRegistryEntry)SerialisationSupport.dummyDataSerializer().setRegistryName(APIReference.TileDataSerializerReference.DUMMY_SERIALIZER_RL));
        event.getRegistry().register((IForgeRegistryEntry)SerialisationSupport.nbtTileDataSerializer().setRegistryName(APIReference.TileDataSerializerReference.NBT_TILE_ENTITY_DATA_SERIALIZER_RL));
        BuildingGadgetsAPI.LOG.trace("Finished Registering Template Serializers");
    }

    static void createOrderedRegistries() {
        BuildingGadgetsAPI.LOG.trace("Creating Ordered Registries");
        Preconditions.checkState((tileDataFactoryBuilder != null ? 1 : 0) != 0, (Object)"Cannot create Ordered Registries twice!");
        tileDataFactories = tileDataFactoryBuilder.build();
        tileDataFactoryBuilder = null;
        BuildingGadgetsAPI.LOG.trace("Finished Creating Ordered Registries");
    }

    static boolean handleIMC(InterModComms.IMCMessage message) {
        BuildingGadgetsAPI.LOG.debug("Received IMC message using Method {} from {}.", (Object)message.getMethod(), (Object)message.getSenderModId());
        if (message.getMethod().equals("imc_tile_data_factory")) {
            BuildingGadgetsAPI.LOG.debug("Recognized ITileDataFactory registration message. Registering.");
            Preconditions.checkState((tileDataFactories != null ? 1 : 0) != 0, (Object)"Attempted to register ITileDataFactory, after the Registry has been built!");
            TopologicalRegistryBuilder builder = (TopologicalRegistryBuilder)((Supplier)message.getMessageSupplier().get()).get();
            tileDataFactoryBuilder.merge(builder);
            BuildingGadgetsAPI.LOG.trace("Registered {} from {} to the ITileDataFactory registry.", (Object)builder, (Object)message.getSenderModId());
            return true;
        }
        return false;
    }

    private static void addDefaultOrdered() {
        tileDataFactoryBuilder.addMarker(APIReference.MARKER_BEFORE_RL).addMarker(APIReference.MARKER_AFTER_RL).addValue(APIReference.TileDataFactoryReference.DATA_PROVIDER_FACTORY_RL, TileSupport.dataProviderFactory()).addDependency(APIReference.MARKER_AFTER_RL, APIReference.TileDataFactoryReference.DATA_PROVIDER_FACTORY_RL);
    }

    static {
        Registries.addDefaultOrdered();
    }

    public static final class TileEntityData {
        public static IOrderedRegistry<ITileDataFactory> getTileDataFactories() {
            Preconditions.checkState((tileDataFactories != null ? 1 : 0) != 0, (Object)"Attempted to retrieve TileDataFactoryRegistry before it was created!");
            return tileDataFactories;
        }

        public static IForgeRegistry<ITileDataSerializer> getTileDataSerializers() {
            Preconditions.checkState((tileDataSerializers != null ? 1 : 0) != 0, (Object)"Attempted to retrieve TileDataSerializerRegistry before registries were created!");
            return tileDataSerializers;
        }
    }
}

