/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.functions.EnchantRandomly;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.loot.StackLootEntry;

public class ChestBuilder {
    protected Random random;
    protected ChestTileEntity chest;
    protected boolean isValid;

    public ChestBuilder(IWorld world, Random rand, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ChestTileEntity) {
            this.random = rand;
            this.chest = (ChestTileEntity)tileEntity;
            this.isValid = true;
        }
    }

    public ChestBuilder(ChestTileEntity tileEntity, Random rand) {
        this.chest = tileEntity;
        if (this.chest != null) {
            this.random = rand;
            this.isValid = true;
        }
    }

    public void fill(ResourceLocation loot) {
        this.chest.func_189404_a(loot, this.random.nextLong());
    }

    public static LootEntry loot(Item item, int min, int max, int weight, int quality) {
        return ChestBuilder.loot(new ItemStack((IItemProvider)item), min, max, weight, quality);
    }

    public static LootEntry loot(Block block, int min, int max, int weight, int quality) {
        return ChestBuilder.loot(new ItemStack((IItemProvider)block), min, max, weight, quality);
    }

    public static LootEntry loot(ItemStack item, int min, int max, int weight, int quality) {
        return new StackLootEntry(item, min, max, weight, quality);
    }

    public static void place(IWorld world, Random random, BlockPos pos, ResourceLocation loot) {
        world.func_180501_a(pos, Blocks.field_150486_ae.func_176223_P(), 2);
        ChestBuilder chest = new ChestBuilder(world, random, pos);
        if (chest.isValid) {
            chest.fill(loot);
        }
    }

    public static void placeTrapped(IWorld world, Random random, BlockPos pos, ResourceLocation loot) {
        world.func_180501_a(pos, Blocks.field_150447_bR.func_176223_P(), 2);
        ChestBuilder chest = new ChestBuilder(world, random, pos);
        if (chest.isValid) {
            chest.fill(loot);
        }
    }

    public static class EnchantedEntry
    extends StackLootEntry {
        final ILootFunction func = EnchantRandomly.func_215900_c().func_216052_b();
        private Item i;

        public EnchantedEntry(Item i, int weight) {
            super((IForgeRegistryEntry<?>)i, 1, 1, weight, 5);
            this.i = i;
        }

        @Override
        protected void func_216154_a(Consumer<ItemStack> list, LootContext ctx) {
            ItemStack s = new ItemStack((IItemProvider)this.i);
            this.func.apply((Object)s, (Object)ctx);
            list.accept(s);
        }
    }
}

