/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.api.DefaultProviderV2;
import net.blay09.mods.craftingtweaks.api.RotationHandler;
import net.blay09.mods.craftingtweaks.api.SimpleTweakProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;

public class SimpleTweakProviderImpl<T extends Container>
implements SimpleTweakProvider<T> {
    private final RotationHandler smallRotationHandler = new RotationHandler(){

        @Override
        public boolean ignoreSlotId(int slotId) {
            return false;
        }

        @Override
        public int rotateSlotId(int slotId, boolean counterClockwise) {
            if (!counterClockwise) {
                switch (slotId) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 2;
                    }
                }
            } else {
                switch (slotId) {
                    case 1: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                    case 0: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                }
            }
            return 0;
        }
    };
    private Predicate<Container> isContainerValidPredicate;
    private Function<Container, Integer> getGridStartFunction;
    private final String modid;
    private final DefaultProviderV2 defaultProvider = CraftingTweaksAPI.createDefaultProviderV2();
    private int gridSlotNumber = 1;
    private int gridSize = 9;
    private boolean hideButtons;
    private boolean phantomItems;
    private TweakSettings tweakRotate = new TweakSettings(true, true, -16, 16);
    private TweakSettings tweakBalance = new TweakSettings(true, true, -16, 34);
    private TweakSettings tweakClear = new TweakSettings(true, true, -16, 52);
    private Direction alignToGrid;

    public SimpleTweakProviderImpl(String modid) {
        this.modid = modid;
    }

    @Override
    public void setAlignToGrid(@Nullable Direction direction) {
        this.alignToGrid = direction;
    }

    @Override
    public void setTweakRotate(boolean enabled, boolean showButton, int x, int y) {
        this.tweakRotate = new TweakSettings(enabled, showButton, x, y);
    }

    @Override
    public void setTweakBalance(boolean enabled, boolean showButton, int x, int y) {
        this.tweakBalance = new TweakSettings(enabled, showButton, x, y);
    }

    @Override
    public void setTweakClear(boolean enabled, boolean showButton, int x, int y) {
        this.tweakClear = new TweakSettings(enabled, showButton, x, y);
    }

    @Override
    public void setPhantomItems(boolean phantomItems) {
        this.phantomItems = phantomItems;
    }

    @Override
    public void setGrid(int slotNumber, int size) {
        this.gridSlotNumber = slotNumber;
        this.gridSize = size;
    }

    @Override
    public void setHideButtons(boolean hideButtons) {
        this.hideButtons = hideButtons;
    }

    @Override
    public String getModId() {
        return this.modid;
    }

    @Override
    public boolean load() {
        return true;
    }

    @Override
    public void clearGrid(PlayerEntity entityPlayer, T container, int id, boolean forced) {
        if (this.tweakClear.enabled) {
            this.defaultProvider.clearGrid(this, id, entityPlayer, container, this.phantomItems, forced);
        }
    }

    @Override
    public void rotateGrid(PlayerEntity entityPlayer, T container, int id, boolean counterClockwise) {
        if (this.tweakRotate.enabled) {
            this.defaultProvider.rotateGrid(this, id, entityPlayer, container, this.getCraftingGridSize(entityPlayer, container, id) == 4 ? this.smallRotationHandler : this.defaultProvider.getRotationHandler(), counterClockwise);
        }
    }

    @Override
    public void balanceGrid(PlayerEntity entityPlayer, T container, int id) {
        if (this.tweakBalance.enabled) {
            this.defaultProvider.balanceGrid(this, id, entityPlayer, container);
        }
    }

    @Override
    public void spreadGrid(PlayerEntity entityPlayer, T container, int id) {
        if (this.tweakBalance.enabled) {
            this.defaultProvider.spreadGrid(this, id, entityPlayer, container);
        }
    }

    @Override
    public boolean canTransferFrom(PlayerEntity entityPlayer, T container, int id, Slot sourceSlot) {
        return this.defaultProvider.canTransferFrom(entityPlayer, container, sourceSlot);
    }

    @Override
    public boolean transferIntoGrid(PlayerEntity entityPlayer, T container, int id, Slot sourceSlot) {
        return this.defaultProvider.transferIntoGrid(this, id, entityPlayer, container, sourceSlot);
    }

    @Override
    public ItemStack putIntoGrid(PlayerEntity entityPlayer, T container, int id, ItemStack itemStack, int index) {
        return this.defaultProvider.putIntoGrid(this, id, entityPlayer, container, itemStack, index);
    }

    @Override
    public IInventory getCraftMatrix(PlayerEntity entityPlayer, T container, int id) {
        return ((Slot)((Container)container).field_75151_b.get((int)this.getCraftingGridStart((PlayerEntity)entityPlayer, container, (int)id))).field_75224_c;
    }

    @Override
    public boolean requiresServerSide() {
        return this.phantomItems;
    }

    @Override
    public int getCraftingGridStart(PlayerEntity entityPlayer, T container, int id) {
        if (this.getGridStartFunction != null) {
            return this.getGridStartFunction.apply((Container)container);
        }
        return this.gridSlotNumber;
    }

    @Override
    public int getCraftingGridSize(PlayerEntity entityPlayer, T container, int id) {
        return this.gridSize;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initGui(ContainerScreen<T> guiContainer, GuiScreenEvent.InitGuiEvent event) {
        if (!this.hideButtons) {
            int buttonY;
            int buttonX;
            int index = 0;
            if (this.tweakRotate.enabled && this.tweakRotate.showButton) {
                buttonX = this.tweakRotate.buttonX;
                buttonY = this.tweakRotate.buttonY;
                if (this.alignToGrid != null) {
                    buttonX = this.getButtonX(guiContainer, index);
                    buttonY = this.getButtonY(guiContainer, index);
                }
                event.addWidget((Widget)CraftingTweaksAPI.createRotateButtonRelative(0, guiContainer, buttonX, buttonY));
                ++index;
            }
            if (this.tweakBalance.enabled && this.tweakBalance.showButton) {
                buttonX = this.tweakBalance.buttonX;
                buttonY = this.tweakBalance.buttonY;
                if (this.alignToGrid != null) {
                    buttonX = this.getButtonX(guiContainer, index);
                    buttonY = this.getButtonY(guiContainer, index);
                }
                event.addWidget((Widget)CraftingTweaksAPI.createBalanceButtonRelative(0, guiContainer, buttonX, buttonY));
                ++index;
            }
            if (this.tweakClear.enabled && this.tweakClear.showButton) {
                buttonX = this.tweakClear.buttonX;
                buttonY = this.tweakClear.buttonY;
                if (this.alignToGrid != null) {
                    buttonX = this.getButtonX(guiContainer, index);
                    buttonY = this.getButtonY(guiContainer, index);
                }
                event.addWidget((Widget)CraftingTweaksAPI.createClearButtonRelative(0, guiContainer, buttonX, buttonY));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getButtonX(ContainerScreen<T> guiContainer, int index) {
        Slot firstSlot = (Slot)guiContainer.func_212873_a_().field_75151_b.get(this.getCraftingGridStart((PlayerEntity)Minecraft.func_71410_x().field_71439_g, guiContainer.func_212873_a_(), 0));
        switch (this.alignToGrid) {
            case NORTH: 
            case UP: 
            case SOUTH: 
            case DOWN: {
                return firstSlot.field_75223_e + 18 * index;
            }
            case EAST: {
                return firstSlot.field_75223_e + 54 + 1;
            }
            case WEST: {
                return firstSlot.field_75223_e - 19;
            }
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getButtonY(ContainerScreen<T> guiContainer, int index) {
        Slot firstSlot = (Slot)guiContainer.func_212873_a_().field_75151_b.get(this.getCraftingGridStart((PlayerEntity)Minecraft.func_71410_x().field_71439_g, guiContainer.func_212873_a_(), 0));
        switch (this.alignToGrid) {
            case NORTH: 
            case UP: {
                return firstSlot.field_75221_f - 18 - 1;
            }
            case SOUTH: 
            case DOWN: {
                return firstSlot.field_75221_f + 54 + 1;
            }
            case EAST: 
            case WEST: {
                return firstSlot.field_75221_f + 18 * index;
            }
        }
        return 0;
    }

    @Override
    public void setContainerValidPredicate(Predicate<Container> predicate) {
        this.isContainerValidPredicate = predicate;
    }

    @Override
    public void setGetGridStartFunction(Function<Container, Integer> function) {
        this.getGridStartFunction = function;
    }

    @Override
    public boolean isValidContainer(Container container) {
        return this.isContainerValidPredicate == null || this.isContainerValidPredicate.test(container);
    }

    public static class TweakSettings {
        public final boolean enabled;
        public final boolean showButton;
        public final int buttonX;
        public final int buttonY;

        public TweakSettings(boolean enabled, boolean showButton, int buttonX, int buttonY) {
            this.enabled = enabled;
            this.showButton = showButton;
            this.buttonX = buttonX;
            this.buttonY = buttonY;
        }
    }
}

