/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.common.world.layer.GenLayerLand;
import biomesoplenty.common.world.layer.GenLayerNetherBiome;
import biomesoplenty.common.world.layer.GenLayerShoreBOP;
import biomesoplenty.common.world.layer.traits.LazyAreaLayerContextBOP;
import com.google.common.collect.ImmutableList;
import java.util.function.LongFunction;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.AddIslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.VoroniZoomLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public class BOPNetherLayerUtil {
    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> createBiomeFactory(IAreaFactory<T> landFactory, LongFunction<C> contextFactory) {
        IAreaFactory biomeFactory = GenLayerNetherBiome.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(200L));
        biomeFactory = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)biomeFactory, (int)2, contextFactory);
        return biomeFactory;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> ImmutableList<IAreaFactory<T>> createAreaFactories(WorldType worldType, OverworldGenSettings settings, LongFunction<C> contextFactory) {
        int biomeSize = 3;
        IAreaFactory landFactory = GenLayerLand.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        IAreaFactory biomesFactory = BOPNetherLayerUtil.createBiomeFactory(landFactory, contextFactory);
        for (int i = 0; i < biomeSize; ++i) {
            biomesFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000 + i), biomesFactory);
            if (i == 0) {
                biomesFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3L), biomesFactory);
            }
            if (i != 1 && biomeSize != 1) continue;
            biomesFactory = GenLayerShoreBOP.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), biomesFactory);
        }
        biomesFactory = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), biomesFactory);
        IAreaFactory voroniZoomBiomesFactory = VoroniZoomLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(10L), biomesFactory);
        return ImmutableList.of((Object)biomesFactory, (Object)voroniZoomBiomesFactory, (Object)biomesFactory);
    }

    public static Layer[] createGenLayers(long seed, WorldType worldType, OverworldGenSettings settings) {
        ImmutableList factoryList = BOPNetherLayerUtil.createAreaFactories(worldType, settings, seedModifier -> new LazyAreaLayerContextBOP(1, seed, seedModifier));
        Layer biomesLayer = new Layer((IAreaFactory)factoryList.get(0));
        Layer voroniZoomBiomesLayer = new Layer((IAreaFactory)factoryList.get(1));
        Layer biomesLayer2 = new Layer((IAreaFactory)factoryList.get(2));
        return new Layer[]{biomesLayer, voroniZoomBiomesLayer, biomesLayer2};
    }
}

