/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.util;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.silentchaos512.mechanisms.block.IEnergyHandler;

public final class EnergyUtils {
    private EnergyUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static void trySendToNeighbors(IBlockReader world, BlockPos pos, IEnergyHandler energyHandler, int maxSend) {
        for (Direction side : Direction.values()) {
            if (energyHandler.getEnergyStored() == 0) {
                return;
            }
            EnergyUtils.trySendTo(world, pos, energyHandler, maxSend, side);
        }
    }

    public static void trySendTo(IBlockReader world, BlockPos pos, IEnergyHandler energyHandler, int maxSend, Direction side) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(side));
        if (tileEntity != null) {
            IEnergyStorage energy = (IEnergyStorage)energyHandler.getEnergy(side).orElseThrow(IllegalStateException::new);
            tileEntity.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d()).ifPresent(other -> {
                int toSend = energy.extractEnergy(maxSend, true);
                int sent = other.receiveEnergy(toSend, false);
                energy.extractEnergy(sent, false);
            });
        }
    }

    @Nullable
    public static IEnergyStorage getEnergy(IBlockReader world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity != null ? (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY).orElse(null) : null;
    }
}

