/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.init;

import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.alloysmelter.AlloySmelterContainer;
import net.silentchaos512.mechanisms.block.alloysmelter.AlloySmelterScreen;
import net.silentchaos512.mechanisms.block.batterybox.BatteryBoxContainer;
import net.silentchaos512.mechanisms.block.batterybox.BatteryBoxScreen;
import net.silentchaos512.mechanisms.block.compressor.CompressorContainer;
import net.silentchaos512.mechanisms.block.compressor.CompressorScreen;
import net.silentchaos512.mechanisms.block.crusher.CrusherContainer;
import net.silentchaos512.mechanisms.block.crusher.CrusherScreen;
import net.silentchaos512.mechanisms.block.electricfurnace.ElectricFurnaceContainer;
import net.silentchaos512.mechanisms.block.electricfurnace.ElectricFurnaceScreen;
import net.silentchaos512.mechanisms.block.generator.coal.CoalGeneratorContainer;
import net.silentchaos512.mechanisms.block.generator.coal.CoalGeneratorScreen;
import net.silentchaos512.mechanisms.block.generator.lava.LavaGeneratorContainer;
import net.silentchaos512.mechanisms.block.generator.lava.LavaGeneratorScreen;

public final class ModContainers {
    public static ContainerType<AlloySmelterContainer> alloySmelter;
    public static ContainerType<BatteryBoxContainer> batteryBox;
    public static ContainerType<CoalGeneratorContainer> coalGenerator;
    public static ContainerType<CompressorContainer> compressor;
    public static ContainerType<CrusherContainer> crusher;
    public static ContainerType<ElectricFurnaceContainer> electricFurnace;
    public static ContainerType<LavaGeneratorContainer> lavaGenerator;

    private ModContainers() {
    }

    public static void registerAll(RegistryEvent.Register<ContainerType<?>> event) {
        alloySmelter = ModContainers.register("alloy_smelter", AlloySmelterContainer::new);
        batteryBox = ModContainers.register("battery_box", BatteryBoxContainer::new);
        coalGenerator = ModContainers.register("coal_generator", CoalGeneratorContainer::new);
        compressor = ModContainers.register("compressor", CompressorContainer::new);
        crusher = ModContainers.register("crusher", CrusherContainer::new);
        electricFurnace = ModContainers.register("electric_furnace", ElectricFurnaceContainer::new);
        lavaGenerator = ModContainers.register("lava_generator", LavaGeneratorContainer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerScreens(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(alloySmelter, AlloySmelterScreen::new);
        ScreenManager.func_216911_a(batteryBox, BatteryBoxScreen::new);
        ScreenManager.func_216911_a(coalGenerator, CoalGeneratorScreen::new);
        ScreenManager.func_216911_a(compressor, CompressorScreen::new);
        ScreenManager.func_216911_a(crusher, CrusherScreen::new);
        ScreenManager.func_216911_a(electricFurnace, ElectricFurnaceScreen::new);
        ScreenManager.func_216911_a(lavaGenerator, LavaGeneratorScreen::new);
    }

    private static <C extends Container> ContainerType<C> register(String name, ContainerType.IFactory<C> containerFactory) {
        ContainerType type = new ContainerType(containerFactory);
        type.setRegistryName(SilentMechanisms.getId(name));
        ForgeRegistries.CONTAINERS.register((IForgeRegistryEntry)type);
        return type;
    }
}

