/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.generator.lava;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.mechanisms.block.generator.AbstractFluidFuelGeneratorTileEntity;
import net.silentchaos512.mechanisms.block.generator.lava.LavaGeneratorContainer;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.init.ModTileEntities;
import net.silentchaos512.mechanisms.util.TextUtil;

public class LavaGeneratorTileEntity
extends AbstractFluidFuelGeneratorTileEntity {
    public static final int MAX_ENERGY = 50000;
    public static final int MAX_SEND = 500;
    public static final int ENERGY_CREATED_PER_TICK = 100;
    public static final int TICKS_PER_MILLIBUCKET = 5;

    public LavaGeneratorTileEntity() {
        super(ModTileEntities.lavaGenerator, 2, 50000, 0, 500, new FluidTank(4000, s -> s.getFluid().func_207185_a(FluidTags.field_206960_b)));
    }

    public IFluidHandler getTank() {
        return this.tank;
    }

    @Override
    protected boolean hasFuel() {
        return this.tank.getFluidAmount() > 0;
    }

    @Override
    protected void consumeFuel() {
        this.tank.drain(1, IFluidHandler.FluidAction.EXECUTE);
        this.burnTime = 5;
    }

    @Override
    protected int getEnergyCreatedPerTick() {
        return 100;
    }

    @Override
    protected BlockState getActiveState() {
        return (BlockState)ModBlocks.lavaGenerator.func_176223_P().func_206870_a((IProperty)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(true));
    }

    @Override
    protected BlockState getInactiveState() {
        return (BlockState)ModBlocks.lavaGenerator.func_176223_P().func_206870_a((IProperty)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void func_73660_a() {
        ItemStack input = this.func_70301_a(0);
        if (!input.func_190926_b() && input.func_77973_b() instanceof BucketItem) {
            this.tryFillTankWithBucket(input);
        }
        super.func_73660_a();
    }

    private void tryFillTankWithBucket(ItemStack input) {
        Fluid fluid = ((BucketItem)input.func_77973_b()).getFluid();
        FluidStack fluidStack = new FluidStack(fluid, 1000);
        if (this.canAcceptLavaBucket(input, fluidStack)) {
            this.tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.sendUpdate(this.func_195044_w(), true);
            this.func_70299_a(0, input.getContainerItem());
            ItemStack input2 = this.func_70301_a(0);
            if (!input2.func_190926_b()) {
                ItemStack output = this.func_70301_a(1);
                if (output.func_190926_b()) {
                    this.func_70299_a(1, input2);
                    this.func_70299_a(0, ItemStack.field_190927_a);
                } else if (InventoryUtils.canItemsStack((ItemStack)this.func_70301_a(0), (ItemStack)output)) {
                    output.func_190917_f(1);
                    input2.func_190918_g(1);
                }
            }
        }
    }

    private boolean canAcceptLavaBucket(ItemStack input, FluidStack fluid) {
        ItemStack output = this.func_70301_a(1);
        return !(!this.tank.isFluidValid(0, fluid) || this.tank.fill(fluid, IFluidHandler.FluidAction.SIMULATE) != 1000 || !output.func_190926_b() && !InventoryUtils.canItemsStack((ItemStack)input.getContainerItem(), (ItemStack)output) || !output.func_190926_b() && output.func_190916_E() >= output.func_77976_d());
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return index == 0 && stack.func_77973_b() instanceof BucketItem && ((BucketItem)stack.func_77973_b()).getFluid().func_207185_a(FluidTags.field_206960_b);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "lava_generator", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new LavaGeneratorContainer(id, playerInventory, this, this.fields);
    }
}

