/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomlib.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.randomlib.config.Config;
import com.therandomlabs.randomlib.config.ConfigException;
import com.therandomlabs.randomlib.config.TRLCategory;
import com.therandomlabs.randomlib.config.adapter.TypeAdapter;
import com.therandomlabs.randomlib.config.adapter.TypeAdapters;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

final class TRLProperty {
    final TRLCategory category;
    final String name;
    final Field field;
    final String fullyQualifiedName;
    final String languageKey;
    final String previous;
    final TypeAdapter adapter;
    final Class<?> clazz;
    final boolean isArray;
    final boolean isResourceLocation;
    final Class<?> enumClass;
    final Enum[] enumConstants;
    final String[] validValues;
    final String[] validValuesDisplay;
    final boolean requiresMCRestart;
    final boolean requiresWorldReload;
    final boolean nonNull;
    final double min;
    final double max;
    final String[] blacklist;
    final String comment;
    Object defaultValue;

    TRLProperty(TRLCategory category, String name, Field field, String comment, String previous) {
        double largestMax;
        double smallestMin;
        this.category = category;
        this.name = name;
        this.field = field;
        this.fullyQualifiedName = this.category.getFullyQualifiedName() + "." + name;
        this.languageKey = this.category.getLanguageKeyPrefix() + name;
        this.previous = previous;
        this.clazz = field.getType();
        if (Enum.class.isAssignableFrom(this.clazz)) {
            this.enumClass = this.clazz;
            this.adapter = TypeAdapters.get(String.class);
        } else if (Enum[].class.isAssignableFrom(this.clazz)) {
            this.enumClass = this.clazz.getComponentType();
            this.adapter = TypeAdapters.get(String[].class);
        } else {
            this.enumClass = null;
            this.adapter = TypeAdapters.get(this.clazz);
        }
        if (this.adapter == null) {
            throw new ConfigException(name, new UnsupportedOperationException("Invalid configuration property type: " + this.clazz.getName()));
        }
        if (this.enumClass == null) {
            this.enumConstants = null;
            this.validValues = null;
            this.validValuesDisplay = null;
        } else {
            ArrayList<String> validValues = new ArrayList<String>();
            ArrayList<String> validValuesDisplay = new ArrayList<String>();
            for (Enum element : this.enumConstants = (Enum[])this.enumClass.getEnumConstants()) {
                validValues.add(element.name());
                validValuesDisplay.add(element.toString());
            }
            this.validValues = validValues.toArray(new String[0]);
            this.validValuesDisplay = validValuesDisplay.toArray(new String[0]);
        }
        this.isArray = this.adapter.isArray();
        this.isResourceLocation = IForgeRegistryEntry.class.isAssignableFrom(this.clazz);
        Object defaultValue = null;
        try {
            defaultValue = field.get(null);
        }
        catch (IllegalAccessException ex) {
            TRLUtils.crashReport("Failed to load default value of configuration property", ex);
        }
        boolean bl = this.nonNull = field.getAnnotation(Config.NonNull.class) != null;
        if (defaultValue == null && (!this.isResourceLocation || this.nonNull)) {
            throw new IllegalArgumentException("Default value of configuration property may not be null unless it is a registry entry without the @Config.NonNull annotation");
        }
        this.defaultValue = defaultValue;
        this.requiresMCRestart = field.getAnnotation(Config.RequiresMCRestart.class) != null;
        boolean bl2 = this.requiresWorldReload = field.getAnnotation(Config.RequiresWorldReload.class) != null;
        if (this.requiresMCRestart && this.requiresWorldReload) {
            throw new IllegalArgumentException("A property cannot both require a Minecraft restart and a world reload");
        }
        if (defaultValue instanceof Byte) {
            smallestMin = -128.0;
            largestMax = 127.0;
        } else if (defaultValue instanceof Float) {
            smallestMin = -3.4028234663852886E38;
            largestMax = 3.4028234663852886E38;
        } else if (defaultValue instanceof Integer) {
            smallestMin = -2.147483648E9;
            largestMax = 2.147483647E9;
        } else if (defaultValue instanceof Long) {
            smallestMin = -9.223372036854776E18;
            largestMax = 9.223372036854776E18;
        } else if (defaultValue instanceof Short) {
            smallestMin = -32768.0;
            largestMax = 32767.0;
        } else {
            smallestMin = -1.7976931348623157E308;
            largestMax = Double.MAX_VALUE;
        }
        Config.RangeInt rangeInt = field.getAnnotation(Config.RangeInt.class);
        Config.RangeDouble rangeDouble = field.getAnnotation(Config.RangeDouble.class);
        double min = -1.7976931348623157E308;
        double max = Double.MAX_VALUE;
        if (rangeInt != null) {
            if (rangeDouble != null) {
                throw new IllegalArgumentException("Two ranges cannot be defined");
            }
            min = rangeInt.min();
            max = rangeInt.max();
            if (min == -2.147483648E9 && min < smallestMin) {
                min = smallestMin;
            }
            if (max == 2.147483647E9 && max > largestMax) {
                max = largestMax;
            }
            if (min > max) {
                throw new IllegalArgumentException("min cannot be larger than max");
            }
        } else if (rangeDouble != null) {
            min = rangeDouble.min();
            max = rangeDouble.max();
            if (min == -1.7976931348623157E308) {
                min = smallestMin;
            }
            if (max == Double.MAX_VALUE) {
                max = largestMax;
            }
            if (min > max) {
                throw new IllegalArgumentException("min cannot be larger than max");
            }
        }
        if (min == -1.7976931348623157E308) {
            min = smallestMin;
        }
        if (max == Double.MAX_VALUE) {
            max = largestMax;
        }
        if (min < smallestMin) {
            throw new IllegalArgumentException(String.format("min is too small: %s < %s", min, smallestMin));
        }
        if (max > largestMax) {
            throw new IllegalArgumentException(String.format("max is too large: %s > %s", max, largestMax));
        }
        this.min = min;
        this.max = max;
        Config.Blacklist blacklist = field.getAnnotation(Config.Blacklist.class);
        String[] stringArray = this.blacklist = blacklist == null ? null : blacklist.value();
        if (this.isArray) {
            for (Object element : TRLUtils.toBoxedArray(defaultValue)) {
                if (!ArrayUtils.contains((Object[])this.blacklist, (Object)this.adapter.asString(element))) continue;
                throw new IllegalArgumentException("Default value is blacklisted");
            }
        } else if (ArrayUtils.contains((Object[])this.blacklist, (Object)this.adapter.asString(defaultValue))) {
            throw new IllegalArgumentException("Default value is blacklisted");
        }
        StringBuilder commentBuilder = new StringBuilder(comment);
        if (this.enumConstants != null) {
            commentBuilder.append("\n Valid values:");
            for (Enum element : this.enumConstants) {
                commentBuilder.append("\n ").append(element.name());
            }
        }
        if (defaultValue instanceof Number) {
            if (defaultValue instanceof Double || defaultValue instanceof Float) {
                commentBuilder.append("\n Min: ").append(min).append("\n Max: ").append(max);
            } else {
                commentBuilder.append("\n Min: ").append((long)min).append("\n Max: ").append((long)max);
            }
        }
        commentBuilder.append("\n Default: ");
        if (this.isArray) {
            commentBuilder.append(Arrays.stream(TRLUtils.toBoxedArray(defaultValue)).map(this.adapter::asString).collect(Collectors.toList()));
        } else {
            commentBuilder.append(this.adapter.asString(defaultValue));
        }
        this.comment = commentBuilder.toString();
    }

    void reloadDefault() {
        if (!this.isArray) {
            if (this.defaultValue != null) {
                IForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(this.clazz);
                this.defaultValue = registry.getValue(((IForgeRegistryEntry)this.defaultValue).getRegistryName());
            }
            return;
        }
        Object[] oldDefaults = (Object[])this.defaultValue;
        ArrayList<IForgeRegistryEntry> newDefaults = new ArrayList<IForgeRegistryEntry>(oldDefaults.length);
        IForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(this.clazz.getComponentType());
        for (Object oldDefault : oldDefaults) {
            newDefaults.add(registry.getValue(((IForgeRegistryEntry)oldDefault).getRegistryName()));
        }
        this.defaultValue = newDefaults.toArray(Arrays.copyOf(oldDefaults, 0));
    }

    boolean exists(CommentedFileConfig config) {
        return config.contains(this.fullyQualifiedName) || this.previous != null && config.contains(this.previous);
    }

    Object get(CommentedFileConfig config) {
        if (!config.contains(this.fullyQualifiedName)) {
            if (this.previous != null && config.contains(this.previous)) {
                config.set(this.fullyQualifiedName, config.get(this.previous));
            } else {
                this.set(config, this.defaultValue);
            }
        }
        this.set(config, this.adapter.getValue(config, this.fullyQualifiedName, this.defaultValue));
        return this.adapter.getValue(config, this.fullyQualifiedName, this.defaultValue);
    }

    String getAsString(CommentedFileConfig config) {
        return this.adapter.asString(this.get(config));
    }

    void set(CommentedFileConfig config, Object value) {
        config.setComment(this.fullyQualifiedName, this.comment);
        this.adapter.setValue(config, this.fullyQualifiedName, this.validate(value, this.isArray));
    }

    Object validate(Object value, boolean isArray) {
        if (value == null && !this.isResourceLocation) {
            value = this.defaultValue;
        }
        if (isArray) {
            boolean primitive = !(value instanceof Object[]);
            Object[] boxedArray = TRLUtils.toBoxedArray(value);
            ArrayList<Object> filtered = new ArrayList<Object>();
            for (Object element : boxedArray) {
                Object validated;
                if (element == null || (validated = this.validate(element, false)) == null) continue;
                filtered.add(validated);
            }
            Object[] filteredArray = filtered.toArray(Arrays.copyOf(boxedArray, 0));
            return primitive ? TRLUtils.toPrimitiveArray(filteredArray) : filteredArray;
        }
        if (ArrayUtils.contains((Object[])this.blacklist, (Object)this.adapter.asString(value))) {
            return null;
        }
        if (value instanceof Number) {
            double number = ((Number)value).doubleValue();
            if (number < this.min) {
                number = this.min;
            } else if (number > this.max) {
                number = this.max;
            }
            if (value instanceof Byte) {
                return (byte)number;
            }
            if (value instanceof Double) {
                return number;
            }
            if (value instanceof Float) {
                return Float.valueOf((float)number);
            }
            if (value instanceof Integer) {
                return (int)number;
            }
            if (value instanceof Long) {
                return (long)number;
            }
            if (value instanceof Short) {
                return (short)number;
            }
        }
        return value;
    }

    void serialize(CommentedFileConfig config) throws IllegalAccessException {
        Object value = this.validate(this.field.get(null), this.isArray);
        if (value == null) {
            value = this.defaultValue;
        }
        if (this.enumConstants == null) {
            this.set(config, value);
        } else if (!this.isArray) {
            this.set(config, ((Enum)value).name());
        } else {
            this.set(config, Arrays.stream((Enum[])value).map(Enum::name).toArray(String[]::new));
        }
    }

    void deserialize(CommentedFileConfig config) throws IllegalAccessException {
        if (this.enumConstants == null) {
            Object value = this.get(config);
            if (this.nonNull && value == null) {
                this.field.set(null, this.defaultValue);
            } else {
                Object validated = this.validate(value, this.isArray);
                this.field.set(null, validated == null ? this.defaultValue : validated);
            }
            return;
        }
        if (!this.isArray) {
            String value = StringUtils.remove((String)this.getAsString(config), (char)'_');
            for (Enum element : this.enumConstants) {
                if (!StringUtils.remove((String)element.name(), (char)'_').equalsIgnoreCase(value)) continue;
                this.field.set(null, element);
                return;
            }
            this.field.set(null, this.defaultValue);
            return;
        }
        String[] values = (String[])this.get(config);
        ArrayList<Enum> enumValues = new ArrayList<Enum>(values.length);
        block1: for (String value : values) {
            value = StringUtils.remove((String)value, (char)'_');
            for (Enum element : this.enumConstants) {
                if (!StringUtils.remove((String)element.name(), (char)'_').equalsIgnoreCase(value)) continue;
                enumValues.add(element);
                continue block1;
            }
        }
        this.field.set(null, enumValues.toArray((Object[])Array.newInstance(this.enumClass, 0)));
    }
}

