/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomlib.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.randomlib.config.TRLProperty;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class TRLCategory {
    final String fullyQualifiedName;
    final String languageKeyPrefix;
    final String languageKey;
    final Class<?> clazz;
    final String comment;
    final String name;
    final List<TRLProperty> properties = new ArrayList<TRLProperty>();
    final Method onReload;
    final Method onReloadClient;

    TRLCategory(String fullyQualifiedNamePrefix, String languageKeyPrefix, Class<?> clazz, String comment, String name) {
        this.fullyQualifiedName = fullyQualifiedNamePrefix + name;
        this.languageKeyPrefix = languageKeyPrefix;
        this.languageKey = languageKeyPrefix + name;
        this.clazz = clazz;
        this.comment = comment;
        this.name = TRLUtils.MC_VERSION_NUMBER == 8 ? name.toLowerCase(Locale.ENGLISH) : name;
        this.onReload = TRLCategory.getOnReloadMethod(clazz, "onReload");
        this.onReloadClient = TRLCategory.getOnReloadMethod(clazz, "onReloadClient");
    }

    void initialize(CommentedFileConfig config) {
        config.setComment(this.fullyQualifiedName, this.comment);
    }

    void onReload(boolean client) {
        Method method;
        Method method2 = method = client ? this.onReloadClient : this.onReload;
        if (method != null) {
            try {
                method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                TRLUtils.crashReport("Failed to reload configuration category", ex);
            }
        }
    }

    String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    String getLanguageKeyPrefix() {
        return this.languageKey + ".";
    }

    private static Method getOnReloadMethod(Class<?> clazz, String name) {
        int modifiers;
        Method onReload = TRLUtils.findMethod(clazz, name, new Class[0]);
        if (!(onReload == null || Modifier.isPublic(modifiers = onReload.getModifiers()) && Modifier.isStatic(modifiers) && onReload.getReturnType() == Void.TYPE)) {
            throw new IllegalArgumentException(name + " must be public static void");
        }
        return onReload;
    }
}

