/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.network.packets;

import com.progwml6.ironchest.IronChest;
import com.progwml6.ironchest.common.tileentity.CrystalChestTileEntity;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTopStackSyncChest {
    private final int dimension;
    private final BlockPos pos;
    private final NonNullList<ItemStack> topStacks;

    public PacketTopStackSyncChest(int dimension, BlockPos pos, NonNullList<ItemStack> topStacks) {
        this.dimension = dimension;
        this.pos = pos;
        this.topStacks = topStacks;
    }

    public static void encode(PacketTopStackSyncChest msg, PacketBuffer buf) {
        buf.writeInt(msg.dimension);
        buf.writeInt(msg.pos.func_177958_n());
        buf.writeInt(msg.pos.func_177956_o());
        buf.writeInt(msg.pos.func_177952_p());
        buf.writeInt(msg.topStacks.size());
        for (ItemStack stack : msg.topStacks) {
            buf.func_150788_a(stack);
        }
    }

    public static PacketTopStackSyncChest decode(PacketBuffer buf) {
        int dimension = buf.readInt();
        BlockPos pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        int size = buf.readInt();
        NonNullList topStacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        for (int item = 0; item < size; ++item) {
            ItemStack itemStack = buf.func_150791_c();
            topStacks.set(item, (Object)itemStack);
        }
        return new PacketTopStackSyncChest(dimension, pos, (NonNullList<ItemStack>)topStacks);
    }

    public static class Handler {
        public static void handle(PacketTopStackSyncChest message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                TileEntity tile;
                World world = IronChest.proxy.getClientWorld();
                if (world != null && (tile = world.func_175625_s(message.pos)) instanceof CrystalChestTileEntity) {
                    ((CrystalChestTileEntity)tile).receiveMessageFromServer((NonNullList<ItemStack>)message.topStacks);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

