/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.helper.ContributorStore;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TeleportationHandler;
import ovh.corail.tombstone.registry.ModEnchantments;

public class Helper {
    public static final Random random = new Random();
    @Nullable
    public static Boolean isHalloween = null;
    public static boolean isContributor = false;
    public static ContributorStore CONTRIBUTORS = ContributorStore.of();
    private static final Capability.IStorage<ISoulConsumer> NULL_STORAGE = new Capability.IStorage<ISoulConsumer>(){

        @Nullable
        public INBT writeNBT(Capability<ISoulConsumer> capability, ISoulConsumer instance, Direction side) {
            return null;
        }

        public void readNBT(Capability<ISoulConsumer> capability, ISoulConsumer instance, Direction side, INBT nbt) {
        }
    };

    public static boolean isContributor(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return isContributor;
        }
        return CONTRIBUTORS.contains(player);
    }

    public static boolean isDisabledPerk(@Nullable Perk perk) {
        return perk == null || perk.isDisabled();
    }

    public static int getRandom(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float getRandom(float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double getRandom(double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static boolean getRandom() {
        return random.nextBoolean();
    }

    public static String dump(Object o) {
        return ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static boolean existClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> List<T> iterableToList(Iterable<T> it) {
        ArrayList list = new ArrayList();
        it.forEach(list::add);
        return list;
    }

    public static int getDimensionId(IWorld world) {
        return world.func_201675_m().func_186058_p().func_186068_a();
    }

    public static BlockPos getCloserValidPos(World world, BlockPos pos) {
        boolean validY;
        WorldBorder border = world.func_175723_af();
        boolean validXZ = border.func_177746_a(pos);
        boolean bl = validY = !World.func_189509_E((BlockPos)pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!validXZ) {
            x = Math.min(Math.max(pos.func_177958_n(), (int)border.func_177726_b()), (int)border.func_177728_d());
            z = Math.min(Math.max(pos.func_177952_p(), (int)border.func_177736_c()), (int)border.func_177733_e());
        }
        if (!validY) {
            y = Math.max(Math.min(pos.func_177956_o(), world.field_73011_w.getActualHeight()), 0);
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isValidPos(World world, BlockPos pos) {
        return world.func_175723_af().func_177746_a(pos) && !World.func_189509_E((BlockPos)pos);
    }

    public static boolean isValidDimension(int dim) {
        return Helper.getDimensionIds().contains(dim);
    }

    public static List<Integer> getDimensionIds() {
        return DimensionManager.getRegistry().func_201756_e().map(DimensionType::func_186068_a).collect(Collectors.toList());
    }

    public static List<String> getDimensionIdsAsStringList() {
        return Helper.getDimensionIds().stream().map(Object::toString).collect(Collectors.toList());
    }

    public static Location findNearestStructure(ServerWorld world, BlockPos pos, SupportStructures struct, boolean unexplored) {
        BlockPos startingPos = pos;
        for (int nbTry = 0; nbTry < 10; ++nbTry) {
            BlockPos foundPos;
            if (nbTry > 3) {
                startingPos = Helper.getCloserValidPos((World)world, startingPos.func_177982_a(Helper.getRandom(-nbTry * 500, nbTry * 500), 0, Helper.getRandom(-nbTry * 500, nbTry * 500)));
            }
            if ((foundPos = world.func_211157_a(struct.getStructureName(), startingPos, 500, unexplored)) == null || !World.func_175701_a((BlockPos)foundPos)) continue;
            Location structureLoc = new Location(foundPos, (IWorld)world);
            return structureLoc;
        }
        return Location.ORIGIN;
    }

    public static BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        BlockState state;
        IChunk chunk = world.func_217349_x(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (!(blockpos.func_177956_o() < 0 || (state = chunk.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76230_c() && state.func_185904_a() != Material.field_151584_j)) {
            blockpos = blockpos1;
        }
        return blockpos;
    }

    public static Location findSpawnForVillage(ServerWorld world, BlockPos villagePos) {
        return new SpawnHelper(world, Helper.getTopSolidOrLiquidBlock((World)world, villagePos)).findSpawnPlace();
    }

    public static <T extends Entity> T teleportEntity(T entity, Location loc) {
        DimensionType dimType;
        MinecraftServer server;
        if (!entity.field_70170_p.field_72995_K && (server = entity.func_184102_h()) != null && (dimType = DimensionType.func_186069_a((int)loc.dim)) != null) {
            TeleportationHandler.teleportEntity(entity, dimType, (double)loc.x + 0.5, (double)loc.y + 0.1, (double)loc.z + 0.5);
        }
        return entity;
    }

    public static <T extends Entity> T teleportToGrave(T entity, Location loc) {
        return Helper.teleportEntity(entity, new Location(loc.getPos().func_177984_a(), loc.dim));
    }

    public static boolean isRuleKeepInventory(PlayerEntity player) {
        return Helper.isRuleKeepInventory(player.field_70170_p);
    }

    public static boolean isRuleKeepInventory(World world) {
        return world.func_82736_K().func_223586_b(GameRules.field_223600_c);
    }

    public static void removeNoEvent(World world, BlockPos pos) {
        Helper.placeNoEvent(world, pos, Blocks.field_150350_a.func_176223_P());
    }

    public static void placeNoEvent(World world, BlockPos pos, BlockState state) {
        if (!((Boolean)ConfigTombstone.general.gravesBypassGriefingRules.get()).booleanValue()) {
            world.func_180501_a(pos, state, 3);
            return;
        }
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        int k = pos.func_177952_p() & 0xF;
        Chunk chunk = (Chunk)world.func_217349_x(pos);
        ChunkSection[] storageArray = chunk.func_76587_i();
        ChunkSection chunksection = storageArray[j >> 4];
        if (chunksection == Chunk.field_186036_a) {
            if (state.func_196958_f()) {
                return;
            }
            storageArray[j >> 4] = chunksection = new ChunkSection(j >> 4 << 4);
        }
        boolean flag = chunksection.func_76663_a();
        BlockState blockstate = chunksection.func_222629_a(i, j & 0xF, k, state);
        if (blockstate != state) {
            Block block = state.func_177230_c();
            Block block1 = blockstate.func_177230_c();
            chunk.func_217303_b(Heightmap.Type.MOTION_BLOCKING).func_202270_a(i, j, k, state);
            chunk.func_217303_b(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).func_202270_a(i, j, k, state);
            chunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR).func_202270_a(i, j, k, state);
            chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE).func_202270_a(i, j, k, state);
            boolean flag1 = chunksection.func_76663_a();
            if (flag != flag1) {
                world.func_72863_F().func_212863_j_().func_215567_a(pos, flag1);
            }
            if (!world.field_72995_K) {
                blockstate.func_196947_b(world, pos, state, false);
            } else if (block1 != block && blockstate.hasTileEntity()) {
                world.func_175713_t(pos);
            }
            if (chunksection.func_177485_a(i, j & 0xF, k).func_177230_c() == block) {
                TileEntity tileentity;
                if (blockstate.hasTileEntity() && (tileentity = chunk.func_177424_a(pos, Chunk.CreateEntityType.CHECK)) != null) {
                    tileentity.func_145836_u();
                }
                if (!world.field_72995_K) {
                    state.func_215705_a(world, pos, blockstate, false);
                }
                if (state.hasTileEntity()) {
                    TileEntity tileentity1 = chunk.func_177424_a(pos, Chunk.CreateEntityType.CHECK);
                    if (tileentity1 == null) {
                        tileentity1 = state.createTileEntity((IBlockReader)world);
                        world.func_175690_a(pos, tileentity1);
                    } else {
                        tileentity1.func_145836_u();
                    }
                }
                chunk.func_76630_e();
            }
            int oldLight = blockstate.getLightValue((IEnviromentBlockReader)world, pos);
            int oldOpacity = blockstate.func_200016_a((IBlockReader)world, pos);
            if (state.func_200016_a((IBlockReader)world, pos) != oldOpacity || state.getLightValue((IEnviromentBlockReader)world, pos) != oldLight || state.func_215691_g() || blockstate.func_215691_g()) {
                world.func_72863_F().func_212863_j_().func_215568_a(pos);
            }
            world.markAndNotifyBlock(pos, chunk, blockstate, state, 3);
        }
    }

    public static boolean canShowTooltip(@Nullable World world, ItemStack stack) {
        return world != null && ((Boolean)ConfigTombstone.client.showEnhancedTooltips.get() != false || Screen.hasShiftDown());
    }

    public static boolean isDateAroundHalloween() {
        return isHalloween != null && isHalloween != false;
    }

    public static boolean isDateAroundHalloween(LocalDate date) {
        if (isHalloween == null) {
            isHalloween = (Boolean)ConfigTombstone.general.persistantHalloween.get() != false || date.get(ChronoField.MONTH_OF_YEAR) + 1 == 10 && date.get(ChronoField.DAY_OF_MONTH) >= 20 || date.get(ChronoField.MONTH_OF_YEAR) + 1 == 11 && date.get(ChronoField.DAY_OF_MONTH) <= 3;
        }
        return isHalloween;
    }

    public static boolean isNight(World world) {
        return world.func_72826_c(0.0f) >= 0.245f && world.func_72826_c(0.0f) <= 0.755f;
    }

    @Nullable
    public static EffectInstance getRandomEffect(int duration) {
        Effect potion;
        List potions = ForgeRegistries.POTIONS.getValues().stream().filter(p -> {
            if (p == null) {
                return false;
            }
            return Helper.isAllowedEffect(p);
        }).collect(Collectors.toList());
        if (potions.size() > 0 && (potion = (Effect)potions.get(Helper.getRandom(0, potions.size() - 1))) != null) {
            int random = Helper.getRandom(1, 100);
            int level = random < 10 ? 4 : (random < 25 ? 3 : (random < 45 ? 2 : (random < 70 ? 1 : 0)));
            return new EffectInstance(potion, duration, level);
        }
        return null;
    }

    public static void addRandomEffect(PlayerEntity player, int duration, boolean withMessage) {
        EffectInstance effect = Helper.getRandomEffect(duration);
        if (effect != null) {
            if (withMessage && !effect.func_188419_a().func_76393_a().isEmpty()) {
                player.func_145747_a(LangKey.MESSAGE_SPELL_CAST_ON_YOU.getTranslationWithStyle(StyleType.MESSAGE_SPELL, new TranslationTextComponent(effect.func_188419_a().func_76393_a(), new Object[0]).func_150255_a(StyleType.MESSAGE_SPECIAL.getStyle())));
            }
            EntityHelper.addEffect((LivingEntity)player, effect);
        }
    }

    public static boolean isAllowedEffect(EffectInstance effectInstance) {
        return Helper.isAllowedEffect(effectInstance.func_188419_a());
    }

    public static boolean isAllowedEffect(Effect effect) {
        ResourceLocation registryName = effect.getRegistryName();
        return effect.field_220305_b != EffectType.HARMFUL && effect.field_220305_b != EffectType.NEUTRAL && !Helper.containRL((List)ConfigTombstone.general.blackListEffects.get(), registryName);
    }

    public static boolean containRL(List<String> listRL, @Nullable ResourceLocation rl) {
        return rl != null && listRL.stream().anyMatch(p -> p.contains(":") ? rl.toString().equals(p) : rl.func_110624_b().equals(p));
    }

    public static float[] getRGBColor3F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        float[] rgb = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        return rgb;
    }

    public static void fillGradient(int left, int top, int right, int bottom, int color1, int color2, int zLevel, boolean isHorizontal) {
        float[] argb1 = Helper.getRGBColor3F(color1);
        float[] argb2 = Helper.getRGBColor3F(color2);
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.disableAlphaTest();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Helper.makeVertex(bufferbuilder, right, top, zLevel, isHorizontal ? argb2 : argb1);
        Helper.makeVertex(bufferbuilder, left, top, zLevel, argb1);
        Helper.makeVertex(bufferbuilder, left, bottom, zLevel, isHorizontal ? argb1 : argb2);
        Helper.makeVertex(bufferbuilder, right, bottom, zLevel, argb2);
        tessellator.func_78381_a();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableTexture();
    }

    private static void makeVertex(BufferBuilder bufferbuilder, int x, int y, int zLevel, float[] colorArray) {
        bufferbuilder.func_181662_b((double)x, (double)y, (double)zLevel).func_181666_a(colorArray[0], colorArray[1], colorArray[2], 1.0f).func_181675_d();
    }

    public static EnchantmentType addEnchantmentType(String name, Predicate<Item> predic, EnchantmentType fallback) {
        EnchantmentType enchantType = EnchantmentType.create((String)name, predic);
        return enchantType == null ? fallback : enchantType;
    }

    public static Set<Enchantment> getTombstoneEnchantments(ItemStack stack) {
        ListNBT nbttaglist;
        boolean isEnchantedBook;
        boolean bl = isEnchantedBook = stack.func_77973_b() == Items.field_151134_bR;
        if (!isEnchantedBook && ConfigTombstone.enchantments.isEnableEnchantmentSoulbound() && ConfigTombstone.enchantments.isEnableEnchantmentShadowStep()) {
            return Sets.newLinkedHashSet();
        }
        LinkedHashSet list = Sets.newLinkedHashSet();
        ListNBT listNBT = nbttaglist = isEnchantedBook ? EnchantedBookItem.func_92110_g((ItemStack)stack) : stack.func_77986_q();
        if (nbttaglist.size() > 0) {
            String soulboundId = ModEnchantments.soulbound.getRegistryName().toString();
            String shadowStepId = ModEnchantments.shadow_step.getRegistryName().toString();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                String id;
                boolean isSoulBound;
                CompoundNBT nbttagcompound = nbttaglist.func_150305_b(i);
                if (!nbttagcompound.func_150297_b("id", 8) || !(isSoulBound = soulboundId.equals(id = nbttagcompound.func_74779_i("id"))) && !shadowStepId.equals(id)) continue;
                list.add(isSoulBound ? ModEnchantments.soulbound : ModEnchantments.shadow_step);
            }
        }
        return list;
    }

    public static void damageItem(ItemStack stack, int amount, ServerPlayerEntity player, Hand hand) {
        stack.func_222118_a(amount, (LivingEntity)player, serverPlayer -> serverPlayer.func_213334_d(hand));
    }

    public static double getDistance(Vec3i vec1, Vec3i vec2) {
        return Math.sqrt(vec1.func_177951_i(vec2));
    }

    public static Capability.IStorage<ISoulConsumer> getNullStorage() {
        return NULL_STORAGE;
    }
}

