/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.OptionButton;
import net.minecraft.client.settings.AbstractOption;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class IntegerConfigOption
extends AbstractOption {
    private final IntSupplier supplier;
    private final Consumer<Integer> consumer;
    private int max;

    public IntegerConfigOption(String title, IntSupplier supplier, Consumer<Integer> consumer, int max) {
        super(title);
        this.supplier = supplier;
        this.consumer = consumer;
        this.max = max;
    }

    private void set(int value) {
        this.consumer.accept(value);
    }

    public int get() {
        return this.supplier.getAsInt();
    }

    public Widget func_216586_a(GameSettings options, int x, int y, int width) {
        return new OptionButton(x, y, width, 14, this, this.getOptionName(), pressable -> {
            int val = this.supplier.getAsInt() == this.max ? 0 : this.supplier.getAsInt() + 1;
            this.set(val);
            pressable.setMessage(this.getOptionName());
        }){

            protected void renderBg(Minecraft minecraft, int i, int j) {
                this.fillGradient(this.x, this.y, this.x + this.width, this.y + this.height, -16777216, -15458776);
            }
        };
    }

    protected abstract String getOptionName();
}

